/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.StatisticalBarRenderer;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StatisticalBarChartDemo
extends ApplicationFrame {
    public StatisticalBarChartDemo(String title) {
        super(title);
        StatisticalCategoryDataset dataset = this.createDataset();
        CategoryAxis xAxis = new CategoryAxis("Type");
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        xAxis.setCategoryMargin(0.05);
        NumberAxis yAxis = new NumberAxis("Value");
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        JFreeChart chart = new JFreeChart("Statistical Bar Chart Demo", new Font("Helvetica", 1, 14), plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private StatisticalCategoryDataset createDataset() {
        DefaultStatisticalCategoryDataset result = new DefaultStatisticalCategoryDataset();
        result.add(32.5, 17.9, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        result.add(27.8, 11.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        result.add(29.3, 14.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 3"));
        result.add(37.9, 10.3, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 4"));
        result.add(22.9, 7.9, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 1"));
        result.add(21.8, 18.4, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 2"));
        result.add(19.3, 12.4, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 3"));
        result.add(30.3, 20.7, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 4"));
        result.add(12.5, 10.9, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 1"));
        result.add(24.8, 7.4, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 2"));
        result.add(19.3, 13.4, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 3"));
        result.add(17.1, 10.6, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 4"));
        return result;
    }

    public static void main(String[] args) {
        StatisticalBarChartDemo demo = new StatisticalBarChartDemo("Statistical Bar Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

