/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class SurveyResultsDemo
extends ApplicationFrame {
    public SurveyResultsDemo(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(700, 600));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(2.01, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 1"));
        dataset.addValue(2.02, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 3"));
        dataset.addValue(1.97, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 4"));
        dataset.addValue(1.44, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 5"));
        dataset.addValue(1.49, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 6"));
        dataset.addValue(1.49, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 7"));
        dataset.addValue(1.48, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 8"));
        dataset.addValue(4.26, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 9"));
        dataset.addValue(4.08, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 10"));
        dataset.addValue(4.03, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 11"));
        dataset.addValue(3.92, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 12"));
        dataset.addValue(3.99, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 13"));
        dataset.addValue(2.23, (Comparable)((Object)"Results"), (Comparable)((Object)"Category 14"));
        dataset.addValue(2.6, (Comparable)((Object)"Results"), (Comparable)((Object)"Overall"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, dataset, PlotOrientation.HORIZONTAL, false, true, false);
        chart.setBackgroundPaint(Color.white);
        TextTitle title = new TextTitle("Figure 7 | I. Resources - The site offers users relevant, informative and educational resources");
        title.setHorizontalAlignment(HorizontalAlignment.LEFT);
        title.setBackgroundPaint(Color.red);
        title.setPaint(Color.white);
        chart.setTitle(title);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setOutlinePaint(null);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePosition(CategoryAnchor.END);
        plot.setDomainGridlineStroke(new BasicStroke(0.5f));
        plot.setDomainGridlinePaint(Color.black);
        plot.setRangeGridlinesVisible(false);
        plot.clearRangeMarkers();
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(false);
        domainAxis.setCategoryMargin(0.5);
        plot.getRangeAxis().setVisible(false);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, new Color(156, 164, 74));
        renderer.setOutlineStroke(null);
        renderer.setBaseOutlineStroke(null);
        renderer.setItemLabelsVisible(true);
        renderer.setItemLabelFont(new Font("SansSerif", 1, 10));
        ItemLabelPosition position = new ItemLabelPosition(ItemLabelAnchor.INSIDE3, TextAnchor.CENTER_RIGHT);
        renderer.setPositiveItemLabelPosition(position);
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("1. White papers are available.", (Comparable)((Object)"Category 1"), 0.0);
        a1.setFont(new Font("SansSerif", 1, 12));
        a1.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a1.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a1);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("2. White papers enhance users understanding of the firm and its expertise.", (Comparable)((Object)"Category 2"), 0.0);
        a2.setFont(new Font("SansSerif", 0, 12));
        a2.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a2.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a2);
        CategoryTextAnnotation a3 = new CategoryTextAnnotation("3. White papers are relevant to the firm's prospects and clients.", (Comparable)((Object)"Category 3"), 0.0);
        a3.setFont(new Font("SansSerif", 0, 12));
        a3.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a3.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a3);
        CategoryTextAnnotation a4 = new CategoryTextAnnotation("4. White papers are relevant to the firm's positioning.", (Comparable)((Object)"Category 4"), 0.0);
        a4.setFont(new Font("SansSerif", 0, 12));
        a4.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a4.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a4);
        CategoryTextAnnotation a5 = new CategoryTextAnnotation("5. Case studies are available.", (Comparable)((Object)"Category 5"), 0.0);
        a5.setFont(new Font("SansSerif", 1, 12));
        a5.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a5.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a5);
        CategoryTextAnnotation a6 = new CategoryTextAnnotation("6. Case studies enhance users understanding of the firm and its expertise.", (Comparable)((Object)"Category 6"), 0.0);
        a6.setFont(new Font("SansSerif", 0, 12));
        a6.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a6.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a6);
        CategoryTextAnnotation a7 = new CategoryTextAnnotation("7. Case studies are relevant to the firm's prospects and clients.", (Comparable)((Object)"Category 7"), 0.0);
        a7.setFont(new Font("SansSerif", 0, 12));
        a7.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a7.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a7);
        CategoryTextAnnotation a8 = new CategoryTextAnnotation("8. White papers are relevant to the firm's positioning.", (Comparable)((Object)"Category 8"), 0.0);
        a8.setFont(new Font("SansSerif", 0, 12));
        a8.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a8.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a8);
        CategoryTextAnnotation a9 = new CategoryTextAnnotation("9. Case studies are available.", (Comparable)((Object)"Category 9"), 0.0);
        a9.setFont(new Font("SansSerif", 1, 12));
        a9.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a9.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a9);
        CategoryTextAnnotation a10 = new CategoryTextAnnotation("10. Case studies enhance users understanding of the firm and its expertise.", (Comparable)((Object)"Category 10"), 0.0);
        a10.setFont(new Font("SansSerif", 0, 12));
        a10.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a10.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a10);
        CategoryTextAnnotation a11 = new CategoryTextAnnotation("11. Case studies are relevant to the firm's prospects and clients.", (Comparable)((Object)"Category 11"), 0.0);
        a11.setFont(new Font("SansSerif", 0, 12));
        a11.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a11.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a11);
        CategoryTextAnnotation a12 = new CategoryTextAnnotation("12. White papers are relevant to the firm's positioning.", (Comparable)((Object)"Category 12"), 0.0);
        a12.setFont(new Font("SansSerif", 0, 12));
        a12.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a12.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a12);
        CategoryTextAnnotation a13 = new CategoryTextAnnotation("13. Users can easily access resources based on viewer interest.", (Comparable)((Object)"Category 13"), 0.0);
        a13.setFont(new Font("SansSerif", 1, 12));
        a13.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a13.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a13);
        CategoryTextAnnotation a14 = new CategoryTextAnnotation("14. Access to additional hyperlinks enhances users's ability to find relevant information.", (Comparable)((Object)"Category 14"), 0.0);
        a14.setFont(new Font("SansSerif", 1, 12));
        a14.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a14.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a14);
        CategoryTextAnnotation a15 = new CategoryTextAnnotation("15. OVERALL EFFECTIVENESS.", (Comparable)((Object)"Overall"), 0.0);
        a15.setFont(new Font("SansSerif", 1, 12));
        a15.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        a15.setCategoryAnchor(CategoryAnchor.START);
        plot.addAnnotation(a15);
        return chart;
    }

    public static void main(String[] args) {
        SurveyResultsDemo demo = new SurveyResultsDemo("Survey Results Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

