/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.demo.SampleYSymbolicDataset;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.YisSymbolic;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SymbolicChartDemo1
extends ApplicationFrame {
    public SymbolicChartDemo1(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        NumberAxis domainAxis = new NumberAxis("X");
        SymbolicAxis symbolicAxis = new SymbolicAxis("Y", ((YisSymbolic)((Object)dataset)).getYSymbolicValues());
        XYPlot plot = new XYPlot(dataset, domainAxis, symbolicAxis, null);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, new SymbolicXYItemLabelGenerator());
        plot.setRenderer(renderer);
        JFreeChart chart = new JFreeChart(title, plot);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset() {
        String[] sData = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("BY Sample", 40, sData, 4, 20, new String[]{"B Fall", "B Spring", "B Summer", "B Winter"});
        return data;
    }

    public static void main(String[] args) {
        SymbolicChartDemo1 demo = new SymbolicChartDemo1("Symbolic Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

