/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.GradientPaint;
import java.lang.reflect.Array;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.demo.SampleXYSymbolicDataset;
import org.jfree.chart.demo.SampleYSymbolicDataset;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.CombinedDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;
import org.jfree.ui.RefineryUtilities;

public class SymbolicXYPlotDemo {
    public static JFreeChart createXYSymbolicPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        SymbolicAxis xSymbolicAxis = new SymbolicAxis(xAxisLabel, ((XisSymbolic)((Object)data)).getXSymbolicValues());
        SymbolicAxis ySymbolicAxis = new SymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data)).getYSymbolicValues());
        XYPlot plot = new XYPlot(data, xSymbolicAxis, ySymbolicAxis, null);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, new SymbolicXYItemLabelGenerator());
        plot.setRenderer(renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] sData = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("AY Sample", 20, sData, 4, 20, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return data;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] sData = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("BY Sample", 40, sData, 4, 10, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return data;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample1() {
        String[] xsData = new String[]{"Atmosphere", "Continental Ecosystem", "Limnic Ecosystem", "Marine Ecosystem"};
        String[] ysData = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[42];
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 1;
        nArray[17] = 1;
        nArray[18] = 1;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 2;
        nArray[24] = 2;
        nArray[25] = 2;
        nArray[26] = 2;
        nArray[27] = 2;
        nArray[28] = 2;
        nArray[29] = 2;
        nArray[30] = 2;
        nArray[31] = 3;
        nArray[32] = 3;
        nArray[33] = 3;
        nArray[34] = 3;
        nArray[35] = 3;
        nArray[36] = 3;
        nArray[37] = 3;
        nArray[38] = 3;
        nArray[39] = 3;
        nArray[40] = 3;
        nArray[41] = 3;
        nArrayArray[0] = nArray;
        int[][] xd = nArrayArray;
        int[][] nArrayArray2 = new int[1][];
        int[] nArray2 = new int[42];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 7;
        nArray2[4] = 10;
        nArray2[5] = 11;
        nArray2[6] = 12;
        nArray2[7] = 14;
        nArray2[9] = 2;
        nArray2[10] = 3;
        nArray2[11] = 4;
        nArray2[12] = 7;
        nArray2[13] = 8;
        nArray2[14] = 9;
        nArray2[15] = 10;
        nArray2[16] = 11;
        nArray2[17] = 12;
        nArray2[18] = 14;
        nArray2[20] = 1;
        nArray2[21] = 2;
        nArray2[22] = 3;
        nArray2[23] = 4;
        nArray2[24] = 5;
        nArray2[25] = 7;
        nArray2[26] = 8;
        nArray2[27] = 9;
        nArray2[28] = 10;
        nArray2[29] = 13;
        nArray2[30] = 14;
        nArray2[32] = 1;
        nArray2[33] = 2;
        nArray2[34] = 3;
        nArray2[35] = 4;
        nArray2[36] = 5;
        nArray2[37] = 8;
        nArray2[38] = 9;
        nArray2[39] = 10;
        nArray2[40] = 13;
        nArray2[41] = 14;
        nArrayArray2[0] = nArray2;
        int[][] yd = nArrayArray2;
        Integer[][] xData = (Integer[][])SymbolicXYPlotDemo.toArray(xd);
        Integer[][] yData = (Integer[][])SymbolicXYPlotDemo.toArray(yd);
        SampleXYSymbolicDataset xySymbolicData = new SampleXYSymbolicDataset("AXY Sample", xData, yData, xsData, ysData, new String[]{"A"});
        return xySymbolicData;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample2() {
        String[] xsData = new String[]{"Physic pollutant", "Chemical pollutant", "Biological pollutant"};
        String[] ysData = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[15];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 2;
        nArray[14] = 2;
        nArrayArray[0] = nArray;
        int[][] xd = nArrayArray;
        int[][] nArrayArray2 = new int[1][];
        int[] nArray2 = new int[15];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        nArray2[12] = 12;
        nArray2[13] = 13;
        nArray2[14] = 14;
        nArrayArray2[0] = nArray2;
        int[][] yd = nArrayArray2;
        Integer[][] xData = (Integer[][])SymbolicXYPlotDemo.toArray(xd);
        Integer[][] yData = (Integer[][])SymbolicXYPlotDemo.toArray(yd);
        SampleXYSymbolicDataset xySymbolicData = new SampleXYSymbolicDataset("BXY Sample", xData, yData, xsData, ysData, new String[]{"B"});
        return xySymbolicData;
    }

    private static void displayXYSymbolic(String frameTitle, XYDataset data, String chartTitle, String xAxisLabel, String yAxisLabel) {
        JFreeChart chart = SymbolicXYPlotDemo.createXYSymbolicPlot(chartTitle, xAxisLabel, yAxisLabel, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicOverlaid(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Overlaid";
        String xAxisLabel = "Contamination and Type";
        String yAxisLabel = "Pollutant";
        String[] combinedXSymbolicValues = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)data1), (XisSymbolic)((Object)data2));
        String[] combinedYSymbolicValues = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SymbolicAxis hsymbolicAxis = new SymbolicAxis("Contamination and Type", combinedXSymbolicValues);
        SymbolicAxis vsymbolicAxis = new SymbolicAxis("Pollutant", combinedYSymbolicValues);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer(1, null);
        XYPlot plot = new XYPlot(series0, hsymbolicAxis, vsymbolicAxis, renderer1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(1, null);
        plot.setDataset(1, series1);
        plot.setRenderer(1, renderer2);
        JFreeChart chart = new JFreeChart("Pollutant Overlaid", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicCombinedHorizontally(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Horizontally Combined";
        String x1AxisLabel = "Contamination";
        String x2AxisLabel = "Type";
        String yAxisLabel = "Pollutant";
        String[] combinedYSymbolicValues = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        JFreeChart chart = null;
        SymbolicAxis hsymbolicAxis0 = new SymbolicAxis("Contamination", ((XisSymbolic)((Object)data1)).getXSymbolicValues());
        SymbolicAxis hsymbolicAxis1 = new SymbolicAxis("Type", ((XisSymbolic)((Object)data2)).getXSymbolicValues());
        SymbolicAxis symbolicAxis = new SymbolicAxis("Pollutant", combinedYSymbolicValues);
        CombinedRangeXYPlot mainPlot = new CombinedRangeXYPlot(symbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, hsymbolicAxis0, null, renderer);
        XYPlot subplot1 = new XYPlot(series1, hsymbolicAxis1, null, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        chart = new JFreeChart("Pollutant Horizontally Combined", JFreeChart.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicCombinedVertically(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Vertically Combined";
        String xAxisLabel = "Contamination and Type";
        String yAxisLabel = "Pollutant";
        String[] combinedXSymbolicValues = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)data1), (XisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SymbolicAxis hsymbolicAxis = new SymbolicAxis("Contamination and Type", combinedXSymbolicValues);
        SymbolicAxis vsymbolicAxis0 = new SymbolicAxis("Pollutant", ((YisSymbolic)((Object)data1)).getYSymbolicValues());
        SymbolicAxis vsymbolicAxis1 = new SymbolicAxis("Pollutant", ((YisSymbolic)((Object)data2)).getYSymbolicValues());
        CombinedDomainXYPlot mainPlot = new CombinedDomainXYPlot(hsymbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, vsymbolicAxis0, renderer);
        XYPlot subplot1 = new XYPlot(series1, null, vsymbolicAxis1, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        JFreeChart chart = new JFreeChart("Pollutant Vertically Combined", JFreeChart.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static Object toArray(Object arr) {
        if (arr == null) {
            return arr;
        }
        Class<?> cls = arr.getClass();
        if (!cls.isArray()) {
            return arr;
        }
        Class<?> compType = cls.getComponentType();
        int dim = 1;
        while (!compType.isPrimitive()) {
            if (!compType.isArray()) {
                return arr;
            }
            ++dim;
            compType = compType.getComponentType();
        }
        int[] length = new int[dim];
        length[0] = Array.getLength(arr);
        Object[] newarr = null;
        try {
            if (compType.equals(Integer.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Integer"), length);
            } else if (compType.equals(Double.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Double"), length);
            } else if (compType.equals(Long.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Long"), length);
            } else if (compType.equals(Float.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Float"), length);
            } else if (compType.equals(Short.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Short"), length);
            } else if (compType.equals(Byte.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Byte"), length);
            } else if (compType.equals(Character.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Character"), length);
            } else if (compType.equals(Boolean.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Boolean"), length);
            }
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex);
        }
        int i = 0;
        while (i < length[0]) {
            newarr[i] = dim != 1 ? SymbolicXYPlotDemo.toArray(Array.get(arr, i)) : Array.get(arr, i);
            ++i;
        }
        return newarr;
    }

    public static void main(String[] args) {
        SampleXYSymbolicDataset s1 = SymbolicXYPlotDemo.createXYSymbolicSample1();
        SampleXYSymbolicDataset s2 = SymbolicXYPlotDemo.createXYSymbolicSample2();
        SymbolicXYPlotDemo.displayXYSymbolic("Example 1", s1, "Pollutant", "contamination", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolic("Example 2", s2, "Pollutant", "type", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolicCombinedHorizontally("Example 3", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicCombinedVertically("Example 4", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicOverlaid("Example 5", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
    }
}

