/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.demo.SampleYSymbolicDataset;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.CombinedDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.YisSymbolic;
import org.jfree.ui.RefineryUtilities;

public class SymbolicYPlotDemo {
    private static void displayYSymbolic(String frameTitle, XYDataset data, String chartTitle, String xAxisLabel, String yAxisLabel) {
        JFreeChart chart = SymbolicYPlotDemo.createYSymbolicPlot(chartTitle, xAxisLabel, yAxisLabel, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayYSymbolicOverlaid(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Animals Overlaid";
        String xAxisLabel = "Miles";
        String yAxisLabel = "Animal";
        String[] combinedYSymbolicValues = SampleYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        NumberAxis valueAxis = new NumberAxis("Miles");
        SymbolicAxis symbolicAxis = new SymbolicAxis("Animal", combinedYSymbolicValues);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot plot = new XYPlot(series0, valueAxis, symbolicAxis, renderer);
        plot.setDataset(1, series1);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(1, renderer1);
        plot.setDataset(2, series2);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(2, renderer2);
        plot.setDataset(3, series3);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(3, renderer3);
        plot.setDataset(4, series4);
        StandardXYItemRenderer renderer4 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(4, renderer4);
        plot.setDataset(5, series5);
        StandardXYItemRenderer renderer5 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(5, renderer5);
        plot.setDataset(6, series6);
        StandardXYItemRenderer renderer6 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(6, renderer6);
        plot.setDataset(7, series7);
        StandardXYItemRenderer renderer7 = new StandardXYItemRenderer(1, null);
        plot.setRenderer(7, renderer7);
        JFreeChart chart = new JFreeChart("Animals Overlaid", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayYSymbolicCombinedHorizontally(String frameTitle, SampleYSymbolicDataset data1, SampleYSymbolicDataset data2) {
        String title = "Animals Horizontally Combined";
        String xAxisLabel = "Miles";
        String yAxisLabel = null;
        String[] combinedYSymbolicValues = SampleYSymbolicDataset.combineYSymbolicDataset(data1, data2);
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        NumberAxis valueAxis0 = new NumberAxis("Miles");
        NumberAxis valueAxis1 = new NumberAxis("Miles");
        NumberAxis valueAxis2 = new NumberAxis("Miles");
        NumberAxis valueAxis3 = new NumberAxis("Miles");
        NumberAxis valueAxis4 = new NumberAxis("Miles");
        NumberAxis valueAxis5 = new NumberAxis("Miles");
        NumberAxis valueAxis6 = new NumberAxis("Miles");
        NumberAxis valueAxis7 = new NumberAxis("Miles");
        SymbolicAxis symbolicAxis = new SymbolicAxis(yAxisLabel, combinedYSymbolicValues);
        CombinedRangeXYPlot mainPlot = new CombinedRangeXYPlot(symbolicAxis);
        StandardXYItemRenderer renderer0 = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, valueAxis0, null, renderer0);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer(1, null);
        XYPlot subplot1 = new XYPlot(series1, valueAxis1, null, renderer1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(1, null);
        XYPlot subplot2 = new XYPlot(series2, valueAxis2, null, renderer2);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer(1, null);
        XYPlot subplot3 = new XYPlot(series3, valueAxis3, null, renderer3);
        StandardXYItemRenderer renderer4 = new StandardXYItemRenderer(1, null);
        XYPlot subplot4 = new XYPlot(series4, valueAxis4, null, renderer4);
        StandardXYItemRenderer renderer5 = new StandardXYItemRenderer(1, null);
        XYPlot subplot5 = new XYPlot(series5, valueAxis5, null, renderer5);
        StandardXYItemRenderer renderer6 = new StandardXYItemRenderer(1, null);
        XYPlot subplot6 = new XYPlot(series6, valueAxis6, null, renderer6);
        StandardXYItemRenderer renderer7 = new StandardXYItemRenderer(1, null);
        XYPlot subplot7 = new XYPlot(series7, valueAxis7, null, renderer7);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        mainPlot.add(subplot2, 1);
        mainPlot.add(subplot3, 1);
        mainPlot.add(subplot4, 1);
        mainPlot.add(subplot5, 1);
        mainPlot.add(subplot6, 1);
        mainPlot.add(subplot7, 1);
        JFreeChart chart = new JFreeChart("Animals Horizontally Combined", JFreeChart.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame ySymbolicFrame = new ChartFrame(frameTitle, chart);
        ySymbolicFrame.pack();
        RefineryUtilities.positionFrameRandomly(ySymbolicFrame);
        ySymbolicFrame.show();
    }

    private static void displayYSymbolicCombinedVertically(String frameTitle, SampleYSymbolicDataset data1, SampleYSymbolicDataset data2) {
        String title = "Animals Vertically Combined";
        String xAxisLabel = "Miles";
        String yAxisLabel = null;
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        NumberAxis valueAxis = new NumberAxis("Miles");
        SymbolicAxis symbolicAxis1 = new SymbolicAxis(yAxisLabel, data1.getYSymbolicValues());
        SymbolicAxis symbolicAxis2 = new SymbolicAxis(yAxisLabel, data2.getYSymbolicValues());
        CombinedDomainXYPlot mainPlot = new CombinedDomainXYPlot(valueAxis);
        StandardXYItemRenderer renderer0 = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, symbolicAxis1, renderer0);
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer(1, null);
        XYPlot subplot1 = new XYPlot(series1, null, symbolicAxis1, renderer1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(1, null);
        XYPlot subplot2 = new XYPlot(series2, null, symbolicAxis1, renderer2);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer(1, null);
        XYPlot subplot3 = new XYPlot(series3, null, symbolicAxis1, renderer3);
        StandardXYItemRenderer renderer4 = new StandardXYItemRenderer(1, null);
        XYPlot subplot4 = new XYPlot(series4, null, symbolicAxis2, renderer4);
        StandardXYItemRenderer renderer5 = new StandardXYItemRenderer(1, null);
        XYPlot subplot5 = new XYPlot(series5, null, symbolicAxis2, renderer5);
        StandardXYItemRenderer renderer6 = new StandardXYItemRenderer(1, null);
        XYPlot subplot6 = new XYPlot(series6, null, symbolicAxis2, renderer6);
        StandardXYItemRenderer renderer7 = new StandardXYItemRenderer(1, null);
        XYPlot subplot7 = new XYPlot(series7, null, symbolicAxis2, renderer7);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        mainPlot.add(subplot2, 1);
        mainPlot.add(subplot3, 1);
        mainPlot.add(subplot4, 1);
        mainPlot.add(subplot5, 1);
        mainPlot.add(subplot6, 1);
        mainPlot.add(subplot7, 1);
        JFreeChart chart = new JFreeChart("Animals Vertically Combined", JFreeChart.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    public static JFreeChart createYSymbolicPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        NumberAxis valueAxis = new NumberAxis(xAxisLabel);
        SymbolicAxis symbolicAxis = new SymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data)).getYSymbolicValues());
        XYPlot plot = new XYPlot(data, valueAxis, symbolicAxis, null);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, new SymbolicXYItemLabelGenerator());
        plot.setRenderer(renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] sData = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("AY Sample", 20, sData, 4, 20, new String[]{"A Fall", "A Spring", "A Summer", "A Winter"});
        return data;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] sData = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("BY Sample", 40, sData, 4, 20, new String[]{"B Fall", "B Spring", "B Summer", "B Winter"});
        return data;
    }

    public static void main(String[] args) {
        SampleYSymbolicDataset s1 = SymbolicYPlotDemo.createYSymbolicSample1();
        SampleYSymbolicDataset s2 = SymbolicYPlotDemo.createYSymbolicSample2();
        SymbolicYPlotDemo.displayYSymbolic("Example 1", s1, "Animal A", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolic("Example 2", s2, "Animal B", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolicCombinedHorizontally("Example 3", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
        SymbolicYPlotDemo.displayYSymbolicCombinedVertically("Example 4", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
        SymbolicYPlotDemo.displayYSymbolicOverlaid("Example 5", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
    }
}

