/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.JThermometer;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.DefaultValueDataset;

public class ThermometerDemo
extends JPanel {
    protected static final String[] OPTIONS = new String[]{"None", "Right", "Left", "Bulb"};
    protected static final String[] AXIS_OPTIONS = new String[]{"None", "Right", "Left"};
    private DefaultValueDataset data = new DefaultValueDataset(20.0);
    private MeterPlot meterplot = new MeterPlot(this.data);
    private JFreeChart meterchart = new JFreeChart("Meter Chart", JFreeChart.DEFAULT_TITLE_FONT, this.meterplot, false);
    private ChartPanel panelMeter = new ChartPanel(this.meterchart);
    private JPanel jPanel1 = new JPanel();
    private JButton butUp3 = new JButton();
    private JButton butDown3 = new JButton();
    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private JButton butDown2 = new JButton();
    private JButton butUp2 = new JButton();
    private JPanel jPanel5 = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel jPanel6 = new JPanel();
    private JButton butUp1 = new JButton();
    private JButton butDown1 = new JButton();
    private JThermometer thermo1 = new JThermometer();
    private JThermometer thermo2 = new JThermometer();
    private JThermometer thermo3 = new JThermometer();
    private JThermometer[] thermo = new JThermometer[3];
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel7 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private JPanel jPanel9 = new JPanel();
    private GridLayout gridLayout2 = new GridLayout();
    private GridLayout gridLayout3 = new GridLayout();
    private GridLayout gridLayout4 = new GridLayout();
    private JComboBox pickShow0 = new JComboBox<String>(OPTIONS);
    private JComboBox pickShow1 = new JComboBox<String>(OPTIONS);
    private JComboBox pickShow2 = new JComboBox<String>(OPTIONS);
    private JComboBox pickAxis0 = new JComboBox<String>(AXIS_OPTIONS);
    private JComboBox pickAxis1 = new JComboBox<String>(AXIS_OPTIONS);
    private JComboBox pickAxis2 = new JComboBox<String>(AXIS_OPTIONS);
    private JComboBox[] pickShow = new JComboBox[3];
    private JComboBox[] pickAxis = new JComboBox[3];
    private JPanel jPanel10 = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel jPanel11 = new JPanel();
    private JButton butDown4 = new JButton();
    private JButton butUp4 = new JButton();

    public ThermometerDemo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.thermo[0] = this.thermo1;
        this.thermo[1] = this.thermo2;
        this.thermo[2] = this.thermo3;
        this.thermo[0].setValue(0.0);
        this.thermo[1].setValue(0.2);
        this.thermo[2].setValue(0.3);
        this.thermo[0].setBackground(Color.white);
        this.thermo[2].setBackground(Color.white);
        this.thermo[0].setOutlinePaint(null);
        this.thermo[1].setOutlinePaint(null);
        this.thermo[2].setOutlinePaint(null);
        this.thermo[0].setUnits(0);
        this.thermo[1].setUnits(1);
        this.thermo[2].setUnits(2);
        this.thermo[0].setShowValueLines(true);
        this.thermo[0].setFollowDataInSubranges(true);
        this.thermo[1].setValueLocation(1);
        this.thermo[1].setForeground(Color.blue);
        this.thermo[2].setForeground(Color.pink);
        this.thermo[0].setRange(-10.0, 40.0);
        this.thermo[0].setSubrangeInfo(0, -50.0, 20.0, -10.0, 22.0);
        this.thermo[0].setSubrangeInfo(1, 20.0, 24.0, 18.0, 26.0);
        this.thermo[0].setSubrangeInfo(2, 24.0, 100.0, 22.0, 40.0);
        this.thermo[0].addSubtitle("Sea Water Temp");
        this.thermo[1].addSubtitle("Air Temp", new Font("SansSerif", 0, 16));
        this.thermo[2].addSubtitle("Ship Temp", new Font("SansSerif", 3, 20));
        this.thermo[1].setValueFormat(new DecimalFormat("#0.0"));
        this.thermo[2].setValueFormat(new DecimalFormat("#0.00"));
        this.pickShow[0] = this.pickShow0;
        this.pickShow[1] = this.pickShow1;
        this.pickShow[2] = this.pickShow2;
        this.pickAxis[0] = this.pickAxis0;
        this.pickAxis[1] = this.pickAxis1;
        this.pickAxis[2] = this.pickAxis2;
        this.pickAxis[0].setSelectedIndex(2);
        this.pickAxis[1].setSelectedIndex(2);
        this.pickAxis[2].setSelectedIndex(2);
        this.setLayout(this.gridLayout1);
        this.butDown3.setText("<");
        this.butDown3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(2, -1.0);
            }
        });
        this.butUp3.setText(">");
        this.butUp3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(2, 1.0);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel3.setLayout(this.borderLayout3);
        this.butDown2.setText("<");
        this.butDown2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(1, -1.0);
            }
        });
        this.butUp2.setText(">");
        this.butUp2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(1, 1.0);
            }
        });
        this.butUp1.setText(">");
        this.butUp1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(0, 1.0);
            }
        });
        this.butDown1.setText("<");
        this.butDown1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(0, -1.0);
            }
        });
        this.jPanel5.setLayout(this.borderLayout1);
        this.pickShow0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(0);
            }
        });
        this.pickShow1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(1);
            }
        });
        this.pickShow2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(2);
            }
        });
        this.pickAxis0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowAxis(0);
            }
        });
        this.pickAxis1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowAxis(1);
            }
        });
        this.pickAxis2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowAxis(2);
            }
        });
        this.jPanel9.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.jPanel8.setLayout(this.gridLayout3);
        this.jPanel7.setLayout(this.gridLayout4);
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.setBackground(Color.white);
        this.jPanel2.setBackground(Color.white);
        this.jPanel9.setBackground(Color.white);
        this.jPanel10.setLayout(this.borderLayout4);
        this.butDown4.setText("<");
        this.butDown4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setMeterValue(-1.1);
            }
        });
        this.butUp4.setText(">");
        this.butUp4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setMeterValue(1.1);
            }
        });
        this.jPanel1.add((Component)this.thermo3, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.butDown3, null);
        this.jPanel2.add((Component)this.butUp3, null);
        this.jPanel1.add((Component)this.jPanel9, "North");
        this.jPanel9.add((Component)this.pickShow2, null);
        this.jPanel9.add((Component)this.pickAxis2, null);
        this.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.jPanel11, "South");
        this.jPanel11.add((Component)this.butDown4, null);
        this.jPanel11.add((Component)this.butUp4, null);
        this.jPanel4.add((Component)this.butDown2, null);
        this.jPanel4.add((Component)this.butUp2, null);
        this.jPanel3.add((Component)this.jPanel8, "North");
        this.jPanel8.add((Component)this.pickShow1, null);
        this.jPanel8.add((Component)this.pickAxis1, null);
        this.jPanel3.add((Component)this.thermo2, "Center");
        this.jPanel3.add((Component)this.jPanel4, "South");
        this.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.thermo1, "Center");
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.butDown1, null);
        this.jPanel6.add((Component)this.butUp1, null);
        this.jPanel5.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.pickShow0, null);
        this.jPanel7.add((Component)this.pickAxis0, null);
        this.add((Component)this.jPanel3, null);
        this.add((Component)this.jPanel1, null);
        this.jPanel10.add((Component)this.panelMeter, "Center");
    }

    public static void main(String[] args) {
        ThermometerDemo panel = new ThermometerDemo();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(5, 5));
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Thermometer Test");
        frame.getContentPane().add((Component)panel, "Center");
        frame.setSize(700, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    private void setValue(int thermometer, double value) {
        if (thermometer >= 0 && thermometer < 3) {
            try {
                this.thermo[thermometer].setValue(this.thermo[thermometer].getValue().doubleValue() + value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setMeterValue(double value) {
        try {
            double newValue = value;
            if (this.data.getValue() != null) {
                newValue += this.data.getValue().doubleValue();
            }
            this.data.setValue(new Double(newValue));
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void setShowValue(int thermometer) {
        if (thermometer >= 0 && thermometer < 3) {
            this.thermo[thermometer].setValueLocation(this.pickShow[thermometer].getSelectedIndex());
        }
    }

    private void setShowAxis(int thermometer) {
        if (thermometer >= 0 && thermometer < 3) {
            this.thermo[thermometer].setShowAxisLocation(this.pickAxis[thermometer].getSelectedIndex());
        }
    }
}

