/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimePeriodValuesDemo
extends ApplicationFrame {
    public TimePeriodValuesDemo(String title) {
        super(title);
        XYDataset data1 = this.createDataset1();
        XYBarRenderer renderer1 = new XYBarRenderer();
        DateAxis domainAxis = new DateAxis("Date");
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setTickUnit(new DateTickUnit(3, 1));
        domainAxis.setDateFormatOverride(new SimpleDateFormat("hh:mm"));
        domainAxis.setLowerMargin(0.01);
        domainAxis.setUpperMargin(0.01);
        NumberAxis rangeAxis = new NumberAxis("Value");
        XYPlot plot = new XYPlot(data1, domainAxis, rangeAxis, renderer1);
        XYDataset data2 = this.createDataset2();
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(3);
        renderer2.setShapesFilled(true);
        plot.setDataset(1, data2);
        plot.setRenderer(1, renderer2);
        JFreeChart chart = new JFreeChart("Supply and Demand", plot);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset1() {
        TimePeriodValues s1 = new TimePeriodValues("Supply");
        TimePeriodValues s2 = new TimePeriodValues("Demand");
        Day today = new Day();
        int i = 0;
        while (i < 24) {
            Minute m0 = new Minute(0, new Hour(i, today));
            Minute m1 = new Minute(15, new Hour(i, today));
            Minute m2 = new Minute(30, new Hour(i, today));
            Minute m3 = new Minute(45, new Hour(i, today));
            Minute m4 = new Minute(0, new Hour(i + 1, today));
            s1.add((TimePeriod)new SimpleTimePeriod(m0.getStart(), m1.getStart()), Math.random());
            s2.add((TimePeriod)new SimpleTimePeriod(m1.getStart(), m2.getStart()), Math.random());
            s1.add((TimePeriod)new SimpleTimePeriod(m2.getStart(), m3.getStart()), Math.random());
            s2.add((TimePeriod)new SimpleTimePeriod(m3.getStart(), m4.getStart()), Math.random());
            ++i;
        }
        TimePeriodValuesCollection dataset = new TimePeriodValuesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    public XYDataset createDataset2() {
        TimePeriodValues s1 = new TimePeriodValues("WebCOINS");
        Day today = new Day();
        int i = 0;
        while (i < 24) {
            Minute m0 = new Minute(0, new Hour(i, today));
            Minute m1 = new Minute(30, new Hour(i, today));
            Minute m2 = new Minute(0, new Hour(i + 1, today));
            s1.add((TimePeriod)new SimpleTimePeriod(m0.getStart(), m1.getStart()), Math.random() * 2.0);
            s1.add((TimePeriod)new SimpleTimePeriod(m1.getStart(), m2.getStart()), Math.random() * 2.0);
            ++i;
        }
        TimePeriodValuesCollection dataset = new TimePeriodValuesCollection();
        dataset.addSeries(s1);
        return dataset;
    }

    public static void main(String[] args) {
        TimePeriodValuesDemo demo = new TimePeriodValuesDemo("Time Period Values Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

