/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimePeriodValuesDemo2
extends ApplicationFrame {
    public TimePeriodValuesDemo2(String title) {
        super(title);
        XYDataset data1 = this.createDataset();
        XYBarRenderer renderer1 = new XYBarRenderer();
        DateAxis domainAxis = new DateAxis("Date");
        NumberAxis rangeAxis = new NumberAxis("Value");
        XYPlot plot = new XYPlot(data1, domainAxis, rangeAxis, renderer1);
        JFreeChart chart = new JFreeChart("Time Period Values Demo", plot);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset() {
        TimePeriodValues s1 = new TimePeriodValues("Series 1");
        Day d1 = new Day();
        Day d2 = (Day)d1.next();
        Day d3 = (Day)d2.next();
        Day d4 = (Day)d3.next();
        Day d5 = (Day)d4.next();
        Day d6 = (Day)d5.next();
        Day d7 = (Day)d6.next();
        s1.add((TimePeriod)new SimpleTimePeriod(d6.getStart(), d6.getEnd()), 74.95);
        s1.add((TimePeriod)new SimpleTimePeriod(d1.getStart(), d2.getEnd()), 55.75);
        s1.add((TimePeriod)new SimpleTimePeriod(d7.getStart(), d7.getEnd()), 90.45);
        s1.add((TimePeriod)new SimpleTimePeriod(d3.getStart(), d5.getEnd()), 105.75);
        TimePeriodValuesCollection dataset = new TimePeriodValuesCollection();
        dataset.addSeries(s1);
        dataset.setDomainIsPointsInTime(false);
        return dataset;
    }

    public static void main(String[] args) {
        TimePeriodValuesDemo2 demo = new TimePeriodValuesDemo2("Time Period Values Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

