/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.date.SerialDate;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class TimeSeriesDemo11
extends ApplicationFrame {
    public TimeSeriesDemo11(String title) {
        super(title);
        JPanel panel = new JPanel(new GridLayout(2, 2));
        panel.setPreferredSize(new Dimension(800, 600));
        Day today = new Day();
        XYDataset dataset = this.createDataset("Series 1", 100.0, today, 365);
        JFreeChart chart1 = this.createChart("Chart 1 : 1 Year", dataset);
        ChartPanel chartPanel1 = new ChartPanel(chart1);
        panel.add(chartPanel1);
        JFreeChart chart2 = this.createChart("Chart 2 : 6 Months", dataset);
        SerialDate t = today.getSerialDate();
        SerialDate t6m = SerialDate.addMonths(-6, t);
        Day sixMonthsAgo = new Day(t6m);
        DateAxis axis2 = (DateAxis)chart2.getXYPlot().getDomainAxis();
        axis2.setRange(sixMonthsAgo.getStart(), today.getEnd());
        ChartPanel chartPanel2 = new ChartPanel(chart2);
        panel.add(chartPanel2);
        JFreeChart chart3 = this.createChart("Chart 3 : 3 Months", dataset);
        SerialDate t3m = SerialDate.addMonths(-3, t);
        Day threeMonthsAgo = new Day(t3m);
        DateAxis axis3 = (DateAxis)chart3.getXYPlot().getDomainAxis();
        axis3.setRange(threeMonthsAgo.getStart(), today.getEnd());
        ChartPanel chartPanel3 = new ChartPanel(chart3);
        panel.add(chartPanel3);
        JFreeChart chart4 = this.createChart("Chart 4 : 1 Month", dataset);
        SerialDate t1m = SerialDate.addMonths(-1, t);
        Day oneMonthsAgo = new Day(t1m);
        DateAxis axis4 = (DateAxis)chart4.getXYPlot().getDomainAxis();
        axis4.setRange(oneMonthsAgo.getStart(), today.getEnd());
        ChartPanel chartPanel4 = new ChartPanel(chart4);
        panel.add(chartPanel4);
        this.setContentPane(panel);
    }

    private JFreeChart createChart(String title, XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, "Date", "Price", dataset, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPaint(Color.blue);
        return chart;
    }

    private XYDataset createDataset(String name, double base, RegularTimePeriod start, int count) {
        TimeSeries series = new TimeSeries(name, start.getClass());
        RegularTimePeriod period = start;
        double value = base;
        int i = 0;
        while (i < count) {
            series.add(period, value);
            period = period.previous();
            value *= 1.0 + (Math.random() - 0.495) / 10.0;
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static void main(String[] args) {
        TimeSeriesDemo11 demo = new TimeSeriesDemo11("Time Series Demo 11");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

