/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class TimeSeriesDemo12
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public TimeSeriesDemo12(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Sample Chart", "Date", "Value", dataset, true, true, false);
        chart.setBackgroundPaint(Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(false);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
            renderer.setSeriesStroke(0, new BasicStroke(2.0f));
            renderer.setSeriesStroke(1, new BasicStroke(2.0f));
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("hh:mma"));
        return chart;
    }

    private XYDataset createDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setDomainIsPointsInTime(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Series 1", clazz);
        s1.add((RegularTimePeriod)new Minute(0, 0, 7, 12, 2003), 1.2);
        s1.add((RegularTimePeriod)new Minute(30, 12, 7, 12, 2003), 3.0);
        s1.add((RegularTimePeriod)new Minute(15, 14, 7, 12, 2003), 8.0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s2 = new TimeSeries("Series 2", clazz2);
        s2.add((RegularTimePeriod)new Minute(0, 3, 7, 12, 2003), 0.0);
        s2.add((RegularTimePeriod)new Minute(30, 9, 7, 12, 2003), 0.0);
        s2.add((RegularTimePeriod)new Minute(15, 10, 7, 12, 2003), 0.0);
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    public static void main(String[] args) {
        TimeSeriesDemo12 demo = new TimeSeriesDemo12("Time Series Demo 12");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

