/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class TimeSeriesDemo13
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public TimeSeriesDemo13(String title) {
        super(title);
        XYDataset dataset1 = this.createDataset(26);
        JFreeChart chart1 = this.createChart(dataset1);
        ChartPanel chartPanel1 = new ChartPanel(chart1);
        XYDataset dataset2 = this.createDataset(1);
        JFreeChart chart2 = this.createChart(dataset2);
        ChartPanel chartPanel2 = new ChartPanel(chart2);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Chart 1", chartPanel1);
        tabs.add("Chart 2", chartPanel2);
        JPanel content = new JPanel(new BorderLayout());
        content.setPreferredSize(new Dimension(500, 270));
        content.add(tabs);
        this.setContentPane(content);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Weekly Data", "Date", "Value", dataset, true, true, false);
        chart.setBackgroundPaint(Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        TickUnits standardUnits = new TickUnits();
        standardUnits.add(new DateTickUnit(2, 1, new SimpleDateFormat("MMM dd ''yy")));
        standardUnits.add(new DateTickUnit(2, 7, new SimpleDateFormat("MMM dd ''yy")));
        standardUnits.add(new DateTickUnit(1, 1, new SimpleDateFormat("MMM ''yy")));
        axis.setStandardTickUnits(standardUnits);
        return chart;
    }

    private XYDataset createDataset(int items) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Week");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Random Data", clazz);
        RegularTimePeriod t = new Week();
        double v = 100.0;
        int i = 0;
        while (i < items) {
            s1.add(t, v);
            v *= 1.0 + (Math.random() - 0.499) / 100.0;
            t = ((RegularTimePeriod)t).next();
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(s1);
        dataset.setDomainIsPointsInTime(true);
        return dataset;
    }

    public static void main(String[] args) {
        TimeSeriesDemo13 demo = new TimeSeriesDemo13("Time Series Demo 13");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

