/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.SeriesException;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo5
extends ApplicationFrame {
    public TimeSeriesDemo5(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        TimeSeries series = new TimeSeries("Random Data");
        Day current = new Day(1, 1, 1990);
        double value = 100.0;
        int i = 0;
        while (i < 4000) {
            try {
                value = value + Math.random() - 0.5;
                series.add((RegularTimePeriod)current, new Double(value));
                current = (Day)current.next();
            }
            catch (SeriesException e) {
                System.err.println("Error adding to series");
            }
            ++i;
        }
        return new TimeSeriesCollection(series);
    }

    private JFreeChart createChart(XYDataset dataset) {
        return ChartFactory.createTimeSeriesChart("Test", "Day", "Value", dataset, false, false, false);
    }

    public static void main(String[] args) {
        String title = "\u20a2\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa";
        TimeSeriesDemo5 demo = new TimeSeriesDemo5("\u20a2\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa");
        demo.pack();
        RefineryUtilities.positionFrameRandomly(demo);
        demo.setVisible(true);
    }
}

