/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.MovingAverage;
import org.jfree.data.XYDataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo8
extends ApplicationFrame {
    public TimeSeriesDemo8(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        TimeSeries eur = DemoDatasetFactory.createEURTimeSeries();
        TimeSeries mav = MovingAverage.createMovingAverage(eur, "30 day moving average", 30, 30);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(eur);
        dataset.addSeries(mav);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Time Series Demo 8", "Date", "Value", dataset, true, true, false);
        XYItemRenderer renderer = chart.getXYPlot().getRenderer();
        StandardXYToolTipGenerator g = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00"));
        renderer.setToolTipGenerator(g);
        return chart;
    }

    public static void main(String[] args) {
        TimeSeriesDemo8 demo = new TimeSeriesDemo8("Time Series Demo 8");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

