/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo9
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public TimeSeriesDemo9(String title) {
        super(title);
        String chartTitle = "Test";
        XYDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Test", "Date", "Price Per Unit", dataset, true, true, false);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer renderer = (StandardXYItemRenderer)r;
            renderer.setPlotShapes(true);
            renderer.setShapesFilled(true);
            renderer.setSeriesShape(0, new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
            renderer.setSeriesShape(1, new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0));
            GeneralPath s2 = new GeneralPath();
            s2.moveTo(0.0f, -3.0f);
            s2.lineTo(3.0f, 3.0f);
            s2.lineTo(-3.0f, 3.0f);
            s2.closePath();
            renderer.setSeriesShape(2, s2);
            GeneralPath s3 = new GeneralPath();
            s3.moveTo(-1.0f, -3.0f);
            s3.lineTo(1.0f, -3.0f);
            s3.lineTo(1.0f, -1.0f);
            s3.lineTo(3.0f, -1.0f);
            s3.lineTo(3.0f, 1.0f);
            s3.lineTo(1.0f, 1.0f);
            s3.lineTo(1.0f, 3.0f);
            s3.lineTo(-1.0f, 3.0f);
            s3.lineTo(-1.0f, 1.0f);
            s3.lineTo(-3.0f, 1.0f);
            s3.lineTo(-3.0f, -1.0f);
            s3.lineTo(-1.0f, -1.0f);
            s3.closePath();
            renderer.setSeriesShape(3, s3);
        }
        plot.getDomainAxis().setVisible(false);
        plot.getRangeAxis().setVisible(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        int i = 0;
        while (i < 4) {
            dataset.addSeries(this.createTimeSeries(i, 10));
            ++i;
        }
        return dataset;
    }

    public TimeSeries createTimeSeries(int series, int count) {
        String string = "Series " + series;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries result = new TimeSeries(string, clazz);
        Day start = new Day();
        int i = 0;
        while (i < count) {
            result.add((RegularTimePeriod)start, Math.random());
            start = (Day)start.next();
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        TimeSeriesDemo9 demo = new TimeSeriesDemo9("Time Series Demo 9");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

