/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.WaferMapDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class WaferMapChartDemo
extends ApplicationFrame {
    public WaferMapChartDemo(String title) {
        super(title);
        WaferMapDataset dataset = DemoDatasetFactory.createRandomWaferMapDataset(5);
        JFreeChart chart = ChartFactory.createWaferMapChart("Wafer Map Demo", dataset, PlotOrientation.VERTICAL, true, false, false);
        Legend legend = chart.getLegend();
        legend.setAnchor(2);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        TextTitle copyright = new TextTitle("JFreeChart WaferMapPlot", new Font("SansSerif", 0, 9));
        copyright.setPosition(RectangleEdge.BOTTOM);
        copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        chart.addSubtitle(copyright);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 400));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        WaferMapChartDemo demo = new WaferMapChartDemo("Wafer Map Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

