/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class WaterTemperatureDemo
extends ApplicationFrame {
    public WaterTemperatureDemo(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        NumberAxis rangeAxis = new NumberAxis("Temperature");
        rangeAxis.setRange(-0.55, -0.15);
        NumberAxis domainAxis = new NumberAxis("Depth");
        domainAxis.setInverted(true);
        domainAxis.setRange(0.0, 35.0);
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        XYPlot plot = new XYPlot(dataset, domainAxis, rangeAxis, renderer);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart("Water Temperature By Depth", plot);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        XYSeries series = new XYSeries("Zone 1");
        series.add(1.0, -0.5);
        series.add(5.0, -0.5);
        series.add(10.0, -0.4);
        series.add(15.0, -0.4);
        series.add(20.0, -0.3);
        series.add(25.0, -0.3);
        series.add(30.0, -0.2);
        series.add(35.0, -0.2);
        return new XYSeriesCollection(series);
    }

    public static void main(String[] args) {
        WaterTemperatureDemo demo = new WaterTemperatureDemo("Water Temperature Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

