/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class WaterfallChartDemo
extends ApplicationFrame {
    public WaterfallChartDemo(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(15.76, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Labour"));
        dataset.addValue(8.66, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Administration"));
        dataset.addValue(4.71, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Marketing"));
        dataset.addValue(3.51, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Distribution"));
        dataset.addValue(32.64, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Total Expense"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createWaterfallChart("Product Cost Breakdown", "Expense Category", "Cost Per Unit", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        ValueAxis rangeAxis = plot.getRangeAxis();
        DecimalFormat formatter = new DecimalFormat("##,###");
        formatter.setNegativePrefix("(");
        formatter.setNegativeSuffix(")");
        TickUnits standardUnits = new TickUnits();
        standardUnits.add(new NumberTickUnit(5.0, formatter));
        standardUnits.add(new NumberTickUnit(10.0, formatter));
        standardUnits.add(new NumberTickUnit(20.0, formatter));
        standardUnits.add(new NumberTickUnit(50.0, formatter));
        standardUnits.add(new NumberTickUnit(100.0, formatter));
        standardUnits.add(new NumberTickUnit(200.0, formatter));
        standardUnits.add(new NumberTickUnit(500.0, formatter));
        standardUnits.add(new NumberTickUnit(1000.0, formatter));
        standardUnits.add(new NumberTickUnit(2000.0, formatter));
        standardUnits.add(new NumberTickUnit(5000.0, formatter));
        rangeAxis.setStandardTickUnits(standardUnits);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        DecimalFormat labelFormatter = new DecimalFormat("$##,###.00");
        labelFormatter.setNegativePrefix("(");
        labelFormatter.setNegativeSuffix(")");
        renderer.setLabelGenerator(new StandardCategoryLabelGenerator("{2}", labelFormatter));
        renderer.setItemLabelsVisible(true);
        return chart;
    }

    public static void main(String[] args) {
        WaterfallChartDemo demo = new WaterfallChartDemo("Waterfall Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

