/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.WaterfallBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RefineryUtilities;

public class WaterfallChartDemo2
extends ApplicationFrame {
    public WaterfallChartDemo2(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(-890.76, (Comparable)((Object)"S1"), (Comparable)((Object)"PY OM"));
        dataset.addValue(-3021.51, (Comparable)((Object)"S1"), (Comparable)((Object)"Vol CM"));
        dataset.addValue(-218.32, (Comparable)((Object)"S1"), (Comparable)((Object)"Price"));
        dataset.addValue(221.75, (Comparable)((Object)"S1"), (Comparable)((Object)"Mat Inf"));
        dataset.addValue(-1504.1, (Comparable)((Object)"S1"), (Comparable)((Object)"Oth Inf"));
        dataset.addValue(7103.8, (Comparable)((Object)"S1"), (Comparable)((Object)"VCP"));
        dataset.addValue(3503.3, (Comparable)((Object)"S1"), (Comparable)((Object)"CM FX"));
        dataset.addValue(-6561.97, (Comparable)((Object)"S1"), (Comparable)((Object)"Base"));
        dataset.addValue(-824.25, (Comparable)((Object)"S1"), (Comparable)((Object)"OM"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        CategoryAxis xAxis = new CategoryAxis("Category");
        NumberAxis yAxis = new NumberAxis("$ in Thousands");
        yAxis.setLowerMargin(0.1);
        yAxis.setUpperMargin(0.1);
        DecimalFormat formatter = new DecimalFormat("##,###");
        formatter.setNegativePrefix("(");
        formatter.setNegativeSuffix(")");
        TickUnits standardUnits = new TickUnits();
        standardUnits.add(new NumberTickUnit(200.0, formatter));
        standardUnits.add(new NumberTickUnit(500.0, formatter));
        standardUnits.add(new NumberTickUnit(1000.0, formatter));
        standardUnits.add(new NumberTickUnit(2000.0, formatter));
        standardUnits.add(new NumberTickUnit(5000.0, formatter));
        yAxis.setStandardTickUnits(standardUnits);
        DecimalFormat labelFormatter = new DecimalFormat("##,###");
        labelFormatter.setNegativePrefix("(");
        labelFormatter.setNegativeSuffix(")");
        WaterfallBarRenderer renderer = new WaterfallBarRenderer();
        renderer.setLabelGenerator(new StandardCategoryLabelGenerator("{2}", labelFormatter));
        renderer.setItemLabelsVisible(Boolean.TRUE);
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.white);
        plot.setRangeGridlinesVisible(true);
        ValueMarker baseline = new ValueMarker(0.0);
        baseline.setPaint(Color.blue);
        baseline.setStroke(new BasicStroke(1.1f));
        plot.addRangeMarker(baseline, Layer.FOREGROUND);
        JFreeChart chart = new JFreeChart("OM WaterFall Chart", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        chart.setBackgroundPaint(Color.white);
        return chart;
    }

    public static void main(String[] args) {
        WaterfallChartDemo2 demo = new WaterfallChartDemo2("Waterfall Chart Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

