/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYAreaRenderer2;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYAreaChartTest
extends ApplicationFrame {
    public XYAreaChartTest(String title) {
        super(title);
        XYSeries series1 = new XYSeries("Random 1");
        series1.add(new Integer(1), (Number)new Double(500.2));
        series1.add(new Integer(2), (Number)new Double(694.1));
        series1.add(new Integer(3), (Number)new Double(-734.4));
        series1.add(new Integer(4), (Number)new Double(453.2));
        series1.add(new Integer(5), (Number)new Double(500.2));
        series1.add(new Integer(6), (Number)new Double(300.7));
        series1.add(new Integer(7), (Number)new Double(734.4));
        series1.add(new Integer(8), (Number)new Double(453.2));
        XYSeries series2 = new XYSeries("Random 2");
        series2.add(new Integer(1), (Number)new Double(700.2));
        series2.add(new Integer(2), (Number)new Double(534.1));
        series2.add(new Integer(3), (Number)new Double(323.4));
        series2.add(new Integer(4), (Number)new Double(125.2));
        series2.add(new Integer(5), (Number)new Double(653.2));
        series2.add(new Integer(6), (Number)new Double(432.7));
        series2.add(new Integer(7), (Number)new Double(564.4));
        series2.add(new Integer(8), (Number)new Double(322.2));
        XYSeriesCollection dataset = new XYSeriesCollection(series1);
        dataset.addSeries(series2);
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYAreaChart("XY Area Chart Test", "Domain (X)", "Range (Y)", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setForegroundAlpha(0.65f);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setRenderer(new XYAreaRenderer2());
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickMarkPaint(Color.black);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setTickMarkPaint(Color.black);
        return chart;
    }

    public static void main(String[] args) {
        XYAreaChartTest demo = new XYAreaChartTest("XY Area Chart Test");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

