/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBarChartDemo
extends ApplicationFrame {
    public XYBarChartDemo(String title) {
        super(title);
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection1();
        data.setDomainIsPointsInTime(false);
        JFreeChart chart = ChartFactory.createXYBarChart(title, "X", true, "Y", data, PlotOrientation.VERTICAL, true, false, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYItemRenderer renderer = chart.getXYPlot().getRenderer();
        StandardXYToolTipGenerator generator = new StandardXYToolTipGenerator("{1} = {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.00"));
        renderer.setToolTipGenerator(generator);
        XYPlot plot = chart.getXYPlot();
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        XYBarChartDemo demo = new XYBarChartDemo("XY Bar Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

