/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYBoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerXYDataset;
import org.jfree.date.DateUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBoxAndWhiskerDemo
extends ApplicationFrame {
    public XYBoxAndWhiskerDemo(String title) {
        super(title);
        BoxAndWhiskerXYDataset dataset = XYBoxAndWhiskerDemo.createSampleDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.getXYPlot().setOrientation(PlotOrientation.VERTICAL);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(600, 400));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(BoxAndWhiskerXYDataset dataset) {
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart("Box-and-Whisker Demo", "Time", "Value", dataset, true);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYBoxAndWhiskerRenderer renderer = (XYBoxAndWhiskerRenderer)plot.getRenderer();
        renderer.setFillBox(false);
        return chart;
    }

    public static BoxAndWhiskerXYDataset createSampleDataset() {
        int entityCount = 14;
        DefaultBoxAndWhiskerXYDataset dataset = new DefaultBoxAndWhiskerXYDataset("Test");
        int i = 0;
        while (i < 14) {
            Date date = DateUtilities.createDate(2003, 7, i + 1, 12, 0);
            ArrayList<Double> values = new ArrayList<Double>();
            int j = 0;
            while (j < 10) {
                values.add(new Double(10.0 + Math.random() * 10.0));
                values.add(new Double(13.0 + Math.random() * 4.0));
                ++j;
            }
            dataset.add(date, BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(values));
            ++i;
        }
        return dataset;
    }

    public static void main(String[] args) {
        XYBoxAndWhiskerDemo demo = new XYBoxAndWhiskerDemo("Box-and-Whisker Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

