/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYLogAxesDemo
extends ApplicationFrame {
    public XYLogAxesDemo(String title) {
        super(title);
        XYSeries s1 = new XYSeries("Series 1");
        XYSeries s2 = new XYSeries("Series 2");
        XYSeries s3 = new XYSeries("Series 3");
        int i = 1;
        while (i <= 50) {
            s1.add((double)i, 10.0 * Math.exp((double)i / 5.0));
            s2.add((double)i, 20.0 * Math.exp((double)i / 5.0));
            s3.add((double)i, 30.0 * Math.exp((double)i / 5.0));
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        dataset.addSeries(s3);
        JFreeChart chart = ChartFactory.createXYLineChart("Log Axis Demo", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis domainAxis = new NumberAxis("x");
        LogarithmicAxis rangeAxis = new LogarithmicAxis("Log(y)");
        plot.setDomainAxis(domainAxis);
        plot.setRangeAxis(rangeAxis);
        chart.setBackgroundPaint(Color.white);
        plot.setOutlinePaint(Color.black);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        XYLogAxesDemo demo = new XYLogAxesDemo("XY Log Axes Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

