/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYStepAreaRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYStepAreaChartDemo
extends ApplicationFrame
implements ActionListener {
    private static final String ORIENT_VERT = "Plot vertical";
    private static final String ORIENT_HORIZ = "Plot horizontal";
    private static final Object[][] TEST_DATA = new Object[][]{{new Integer(1), new Integer(500), Boolean.TRUE}, {new Integer(2), new Integer(694)}, {new Integer(3), new Integer(-734)}, {new Integer(4), new Integer(453)}, {new Integer(5), new Integer(500), Boolean.TRUE}, {new Integer(6), new Integer(200)}, {new Integer(7), new Integer(550), Boolean.TRUE}, {new Integer(8), new Integer(-150), Boolean.TRUE}, {new Integer(9), new Integer(232)}, {new Integer(10), new Integer(734)}, {new Integer(11), new Integer(400), Boolean.TRUE}};
    private ChartPanel chartPanel;
    private XYSeries xySeries = new XYSeries("Some data");
    private JCheckBox nullValuesCheckBox;
    private JCheckBox outlineCheckBox;
    private JTextField rangeBaseTextField;
    private JComboBox orientationComboBox;

    public XYStepAreaChartDemo(String title) {
        super(title);
        int i = 0;
        while (i < TEST_DATA.length) {
            this.xySeries.add((Integer)TEST_DATA[i][0], (Number)((Integer)TEST_DATA[i][1]));
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection(this.xySeries);
        JFreeChart chart = this.createChart(dataset);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        Plot plot = this.chartPanel.getChart().getPlot();
        plot.setOutlineStroke(new BasicStroke(2.0f));
        plot.setOutlinePaint(Color.magenta);
        JPanel main = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel();
        String[] options = new String[]{ORIENT_VERT, ORIENT_HORIZ};
        this.orientationComboBox = new JComboBox<String>(options);
        this.orientationComboBox.addActionListener(this);
        optionsPanel.add(this.orientationComboBox);
        this.outlineCheckBox = new JCheckBox("Outline");
        this.outlineCheckBox.addActionListener(this);
        optionsPanel.add(this.outlineCheckBox);
        optionsPanel.add(new JLabel("Base"));
        this.rangeBaseTextField = new JTextField("0", 5);
        this.rangeBaseTextField.addActionListener(this);
        optionsPanel.add(this.rangeBaseTextField);
        this.nullValuesCheckBox = new JCheckBox("NULL values");
        this.nullValuesCheckBox.addActionListener(this);
        optionsPanel.add(this.nullValuesCheckBox);
        main.add((Component)optionsPanel, "South");
        main.add(this.chartPanel);
        this.setContentPane(main);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYStepAreaChart("XY Step Area Chart Demo", "Domain (X)", "Range (Y)", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = chart.getXYPlot();
        plot.getRenderer().setSeriesPaint(0, Color.green);
        XYStepAreaRenderer rend = (XYStepAreaRenderer)plot.getRenderer();
        rend.setShapesFilled(true);
        return chart;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.nullValuesCheckBox) {
            boolean withNulls = this.nullValuesCheckBox.isSelected();
            int i = 0;
            while (i < TEST_DATA.length) {
                Integer yVal = (Integer)TEST_DATA[i][1];
                if (withNulls && TEST_DATA[i].length > 2) {
                    yVal = null;
                }
                this.xySeries.getDataItem(i).setY(yVal);
                ++i;
            }
        } else if (source == this.outlineCheckBox) {
            XYPlot plot = (XYPlot)this.chartPanel.getChart().getPlot();
            ((XYStepAreaRenderer)plot.getRenderer()).setOutline(this.outlineCheckBox.isSelected());
        } else if (source == this.rangeBaseTextField) {
            double val = Double.parseDouble(this.rangeBaseTextField.getText());
            XYPlot plot = (XYPlot)this.chartPanel.getChart().getPlot();
            XYStepAreaRenderer rend = (XYStepAreaRenderer)plot.getRenderer();
            rend.setRangeBase(val);
        } else if (source == this.orientationComboBox) {
            XYPlot plot = (XYPlot)this.chartPanel.getChart().getPlot();
            if (this.orientationComboBox.getSelectedItem() == ORIENT_HORIZ) {
                plot.setOrientation(PlotOrientation.HORIZONTAL);
            } else if (this.orientationComboBox.getSelectedItem() == ORIENT_VERT) {
                plot.setOrientation(PlotOrientation.VERTICAL);
            }
        }
        this.chartPanel.repaint();
    }

    public static void main(String[] args) {
        XYStepAreaChartDemo demo = new XYStepAreaChartDemo("Step Area XY Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

