/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.date.DateUtilities;
import org.jfree.ui.RefineryUtilities;

public class XYStepChartDemo {
    private ChartFrame frame = null;

    private void displayChart() {
        if (this.frame == null) {
            String title = "LCACs in use at given time";
            String xAxisLabel = "Time";
            String yAxisLabel = "Number of Transports";
            XYDataset data = XYStepChartDemo.createStepXYDataset();
            JFreeChart chart = ChartFactory.createXYStepChart("LCACs in use at given time", "Time", "Number of Transports", data, PlotOrientation.VERTICAL, true, true, false);
            chart.setBackgroundPaint(new Color(216, 216, 216));
            XYPlot plot = chart.getXYPlot();
            plot.getRenderer().setSeriesStroke(0, new BasicStroke(2.0f));
            plot.getRenderer().setSeriesStroke(1, new BasicStroke(2.0f));
            this.frame = new ChartFrame("Plan Comparison", chart);
            this.frame.pack();
            RefineryUtilities.positionFrameRandomly(this.frame);
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(true);
            this.frame.requestFocus();
        }
    }

    public static XYDataset createStepXYDataset() {
        int feb = 2;
        XYSeries s1 = new XYSeries("Plan 1", false, true);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 8, 0).getTime(), 0.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 8, 1).getTime(), 2.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 9, 5).getTime(), 4.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 10, 6).getTime(), 4.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 11, 6).getTime(), 5.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 12, 6).getTime(), 3.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 13, 6).getTime(), 6.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 14, 6).getTime(), 6.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 15, 30).getTime(), 2.0);
        s1.add((double)DateUtilities.createDate(2002, 2, 19, 16, 7).getTime(), 0.0);
        XYSeries s2 = new XYSeries("Plan 2");
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 8, 40).getTime(), 0.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 8, 45).getTime(), 1.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 9, 0).getTime(), 6.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 10, 6).getTime(), 2.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 10, 45).getTime(), 4.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 12, 0).getTime(), 7.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 13, 0).getTime(), 5.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 14, 6).getTime(), 4.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 15, 15).getTime(), 4.0);
        s2.add((double)DateUtilities.createDate(2002, 2, 19, 16, 0).getTime(), 0.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    public static void main(String[] args) {
        XYStepChartDemo demo = new XYStepChartDemo();
        demo.displayChart();
    }
}

