/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class XYTickLabelDemo
extends ApplicationFrame
implements ActionListener {
    private static final int DEFAULT_FONT_SIZE = 13;
    private JFreeChart chart = this.createChart();
    private JCheckBox verticalTickLabelsCheckBox;
    private JCheckBox horizontalPlotCheckBox;
    private JCheckBox symbolicAxesCheckBox;
    private JTextField fontSizeTextField;

    public XYTickLabelDemo(String title) {
        super(title);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(600, 270));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.setContentPane(mainPanel);
        mainPanel.add(chartPanel);
        JPanel optionsPanel = new JPanel();
        mainPanel.add((Component)optionsPanel, "South");
        this.symbolicAxesCheckBox = new JCheckBox("Symbolic axes");
        this.symbolicAxesCheckBox.addActionListener(this);
        optionsPanel.add(this.symbolicAxesCheckBox);
        this.verticalTickLabelsCheckBox = new JCheckBox("Tick labels vertical");
        this.verticalTickLabelsCheckBox.addActionListener(this);
        optionsPanel.add(this.verticalTickLabelsCheckBox);
        this.fontSizeTextField = new JTextField(3);
        this.fontSizeTextField.addActionListener(this);
        optionsPanel.add(new JLabel("Font size:"));
        optionsPanel.add(this.fontSizeTextField);
        ValueAxis axis = this.chart.getXYPlot().getDomainAxis();
        this.fontSizeTextField.setText("13");
        XYPlot plot = this.chart.getXYPlot();
        Font ft = axis.getTickLabelFont();
        ft = ft.deriveFont(13.0f);
        plot.getDomainAxis().setTickLabelFont(ft);
        plot.getRangeAxis().setTickLabelFont(ft);
        plot.getDomainAxis(1).setTickLabelFont(ft);
        plot.getRangeAxis(1).setTickLabelFont(ft);
        this.horizontalPlotCheckBox = new JCheckBox("Plot horizontal");
        this.horizontalPlotCheckBox.addActionListener(this);
        optionsPanel.add(this.horizontalPlotCheckBox);
    }

    public void actionPerformed(ActionEvent event) {
        block6: {
            String s;
            Object source;
            ValueAxis[] axes;
            block7: {
                block5: {
                    int i;
                    boolean val;
                    axes = new ValueAxis[4];
                    XYPlot plot = this.chart.getXYPlot();
                    axes[0] = plot.getDomainAxis();
                    axes[1] = plot.getRangeAxis();
                    axes[2] = plot.getDomainAxis(1);
                    axes[3] = plot.getRangeAxis(1);
                    source = event.getSource();
                    if (source == this.symbolicAxesCheckBox) {
                        val = this.symbolicAxesCheckBox.isSelected();
                        i = 0;
                        while (i < axes.length) {
                            ValueAxis axis = axes[i];
                            String label = axis.getLabel();
                            int maxTick = (int)axis.getUpperBound();
                            String[] tickLabels = new String[maxTick];
                            Font ft = axis.getTickLabelFont();
                            int itk = 0;
                            while (itk < maxTick) {
                                tickLabels[itk] = "Label " + itk;
                                ++itk;
                            }
                            axis = val ? new SymbolicAxis(label, tickLabels) : new NumberAxis(label);
                            axis.setTickLabelFont(ft);
                            axes[i] = axis;
                            ++i;
                        }
                        plot.setDomainAxis(axes[0]);
                        plot.setRangeAxis(axes[1]);
                        plot.setDomainAxis(1, axes[2]);
                        plot.setRangeAxis(1, axes[3]);
                    }
                    if (source != this.symbolicAxesCheckBox && source != this.verticalTickLabelsCheckBox) break block5;
                    val = this.verticalTickLabelsCheckBox.isSelected();
                    i = 0;
                    while (i < axes.length) {
                        axes[i].setVerticalTickLabels(val);
                        ++i;
                    }
                    break block6;
                }
                if (source != this.symbolicAxesCheckBox && source != this.horizontalPlotCheckBox) break block7;
                PlotOrientation val = this.horizontalPlotCheckBox.isSelected() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
                this.chart.getXYPlot().setOrientation(val);
                break block6;
            }
            if (source != this.symbolicAxesCheckBox && source != this.fontSizeTextField || (s = this.fontSizeTextField.getText()).length() <= 0) break block6;
            float sz = Float.parseFloat(s);
            int i = 0;
            while (i < axes.length) {
                ValueAxis axis = axes[i];
                Font ft = axis.getTickLabelFont();
                ft = ft.deriveFont(sz);
                axis.setTickLabelFont(ft);
                ++i;
            }
        }
    }

    private JFreeChart createChart() {
        XYSeries series1 = new XYSeries("Something");
        series1.add(0.0, 30.0);
        series1.add(1.0, 10.0);
        series1.add(2.0, 40.0);
        series1.add(3.0, 30.0);
        series1.add(4.0, 50.0);
        series1.add(5.0, 50.0);
        series1.add(6.0, 70.0);
        series1.add(7.0, 70.0);
        series1.add(8.0, 80.0);
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(series1);
        XYSeries series2 = new XYSeries("Something else");
        series2.add(0.0, 5.0);
        series2.add(1.0, 4.0);
        series2.add(2.0, 1.0);
        series2.add(3.0, 5.0);
        series2.add(4.0, 0.0);
        XYSeriesCollection dataset2 = new XYSeriesCollection();
        dataset2.addSeries(series2);
        JFreeChart result = ChartFactory.createXYLineChart("Tick Label Demo", "Domain Axis 1", "Range Axis 1", dataset1, PlotOrientation.VERTICAL, false, true, false);
        result.setBackgroundPaint(Color.white);
        XYPlot plot = result.getXYPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPaint(Color.black);
        NumberAxis xAxis2 = new NumberAxis("Domain Axis 2");
        xAxis2.setAutoRangeIncludesZero(false);
        plot.setDomainAxis(1, xAxis2);
        DateAxis yAxis1 = new DateAxis("Range Axis 1");
        plot.setRangeAxis(yAxis1);
        DateAxis yAxis2 = new DateAxis("Range Axis 2");
        plot.setRangeAxis(1, yAxis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToDomainAxis(1, 1);
        plot.mapDatasetToRangeAxis(1, 1);
        return result;
    }

    public static void main(String[] args) {
        XYTickLabelDemo demo = new XYTickLabelDemo("Tick Label Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

