/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.data.DefaultCategoryDataset;

public class CategoryItemEntityTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.entity.junit.CategoryItemEntityTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CategoryItemEntityTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryItemEntity e1 = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity e2 = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setToolTipText("New ToolTip");
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setToolTipText("New ToolTip");
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setURLText("New URL");
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setURLText("New URL");
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setCategory("Category 20");
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setCategory("Category 20");
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setCategoryIndex(20);
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setCategoryIndex(20);
        Assert.assertTrue((boolean)e1.equals(e2));
        e1.setSeries(88);
        Assert.assertFalse((boolean)e1.equals(e2));
        e2.setSeries(88);
        Assert.assertTrue((boolean)e1.equals(e2));
    }

    public void testCloning() {
        CategoryItemEntity e1 = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity e2 = null;
        try {
            e2 = (CategoryItemEntity)e1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((e1 != e2 ? 1 : 0) != 0);
        Assert.assertTrue((e1.getClass() == e2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)e1.equals(e2));
    }

    public void testSerialization() {
        CategoryItemEntity e1 = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity e2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(e1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            e2 = (CategoryItemEntity)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)e1, e2);
    }
}

