/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JFreeChartTests
extends TestCase {
    private JFreeChart pieChart;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.junit.JFreeChartTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JFreeChartTests(String name) {
        super(name);
    }

    protected void setUp() {
        DefaultPieDataset data = new DefaultPieDataset();
        data.setValue((Comparable)((Object)"Java"), new Double(43.2));
        data.setValue((Comparable)((Object)"Visual Basic"), new Double(0.0));
        data.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        this.pieChart = ChartFactory.createPieChart("Pie Chart", data, true, true, false);
    }

    public void testSubtitleCount() {
        int count = this.pieChart.getSubtitleCount();
        Assert.assertEquals((int)count, (int)0);
    }

    public void testSerialization1() {
        DefaultPieDataset data = new DefaultPieDataset();
        data.setValue((Comparable)((Object)"Type 1"), 54.5);
        data.setValue((Comparable)((Object)"Type 2"), 23.9);
        data.setValue((Comparable)((Object)"Type 3"), 45.8);
        JFreeChart c1 = ChartFactory.createPieChart("Test", data, true, true, true);
        JFreeChart c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)c1, c2);
    }

    public void testSerialization2() {
        DefaultPieDataset data = new DefaultPieDataset();
        data.setValue((Comparable)((Object)"Type 1"), 54.5);
        data.setValue((Comparable)((Object)"Type 2"), 23.9);
        data.setValue((Comparable)((Object)"Type 3"), 45.8);
        JFreeChart c1 = ChartFactory.createPieChart3D("Test", data, true, true, true);
        JFreeChart c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)c1, c2);
    }

    public void testSerialization3() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        String category6 = "Category 6";
        String category7 = "Category 7";
        String category8 = "Category 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)series1), (Comparable)((Object)category1));
        dataset.addValue(4.0, (Comparable)((Object)series1), (Comparable)((Object)category2));
        dataset.addValue(3.0, (Comparable)((Object)series1), (Comparable)((Object)category3));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)category4));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)category5));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)category6));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)category7));
        dataset.addValue(8.0, (Comparable)((Object)series1), (Comparable)((Object)category8));
        dataset.addValue(5.0, (Comparable)((Object)series2), (Comparable)((Object)category1));
        dataset.addValue(7.0, (Comparable)((Object)series2), (Comparable)((Object)category2));
        dataset.addValue(6.0, (Comparable)((Object)series2), (Comparable)((Object)category3));
        dataset.addValue(8.0, (Comparable)((Object)series2), (Comparable)((Object)category4));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)category5));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)category6));
        dataset.addValue(2.0, (Comparable)((Object)series2), (Comparable)((Object)category7));
        dataset.addValue(1.0, (Comparable)((Object)series2), (Comparable)((Object)category8));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)category1));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category2));
        dataset.addValue(2.0, (Comparable)((Object)series3), (Comparable)((Object)category3));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category4));
        dataset.addValue(6.0, (Comparable)((Object)series3), (Comparable)((Object)category5));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category6));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)category7));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category8));
        JFreeChart c1 = ChartFactory.createBarChart("Vertical Bar Chart", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)c1, c2);
    }

    public void testSerialization4() {
        RegularTimePeriod t = new Day();
        TimeSeries series = new TimeSeries("Series 1");
        series.add(t, 36.4);
        t = ((RegularTimePeriod)t).next();
        series.add(t, 63.5);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        JFreeChart c1 = ChartFactory.createTimeSeriesChart("Test", "Date", "Value", dataset, true, true, true);
        JFreeChart c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)c1, c2);
    }
}

