/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class ScatterPlotTests
extends TestCase {
    private JFreeChart chart;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.junit.ScatterPlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ScatterPlotTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = ScatterPlotTests.createChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        XYSeries series1 = new XYSeries("Series 1");
        series1.add(10.0, 10.0);
        series1.add(20.0, 20.0);
        series1.add(30.0, 30.0);
        XYSeriesCollection dataset = new XYSeriesCollection(series1);
        LocalListener l = new LocalListener();
        this.chart.addChangeListener(l);
        this.chart.getXYPlot().setDataset(dataset);
        Assert.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.chart.getXYPlot().getRangeAxis();
        Range range = axis.getRange();
        Assert.assertTrue((String)("Expecting the lower bound of the range to be around 10: " + range.getLowerBound()), (range.getLowerBound() <= 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expecting the upper bound of the range to be around 30: " + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    private static JFreeChart createChart() {
        XYSeries series1 = new XYSeries("Series 1");
        series1.add(1.0, 1.0);
        series1.add(2.0, 2.0);
        series1.add(3.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection(series1);
        return ChartFactory.createScatterPlot("Scatter Plot", "Domain", "Range", dataset, PlotOrientation.VERTICAL, true, true, false);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

