/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;

public class StackedBarChartTests
extends TestCase {
    private JFreeChart chart;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.junit.StackedBarChartTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public StackedBarChartTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = StackedBarChartTests.createChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        Assert.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        Number[][] data = new Integer[][]{{new Integer(-30), new Integer(-20)}, {new Integer(-10), new Integer(10)}, {new Integer(20), new Integer(30)}};
        CategoryDataset newData = DatasetUtilities.createCategoryDataset("S", "C", data);
        LocalListener l = new LocalListener();
        this.chart.addChangeListener(l);
        this.chart.getCategoryPlot().setDataset(newData);
        Assert.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.chart.getCategoryPlot().getRangeAxis();
        Range range = axis.getRange();
        Assert.assertTrue((String)("Expecting the lower bound of the range to be around -30: " + range.getLowerBound()), (range.getLowerBound() <= -30.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expecting the upper bound of the range to be around 30: " + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    private static JFreeChart createChart() {
        Number[][] data = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("S", "C", data);
        return ChartFactory.createStackedBarChart("Stacked Bar Chart", "Domain", "Range", dataset, PlotOrientation.HORIZONTAL, true, true, false);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

