/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;

public class BoxAndWhiskerToolTipGeneratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.labels.junit.BoxAndWhiskerToolTipGeneratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BoxAndWhiskerToolTipGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        BoxAndWhiskerToolTipGenerator g1 = new BoxAndWhiskerToolTipGenerator();
        BoxAndWhiskerToolTipGenerator g2 = new BoxAndWhiskerToolTipGenerator();
        Assert.assertTrue((boolean)g1.equals(g2));
        Assert.assertTrue((boolean)g2.equals(g1));
        g1 = new BoxAndWhiskerToolTipGenerator("{0} --> {1} {2}", new DecimalFormat("0.0"));
        g2 = new BoxAndWhiskerToolTipGenerator("{1} {2}", new DecimalFormat("0.0"));
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new BoxAndWhiskerToolTipGenerator("{0} --> {1} {2}", new DecimalFormat("0.0"));
        Assert.assertTrue((boolean)g1.equals(g2));
        g1 = new BoxAndWhiskerToolTipGenerator("{0} --> {1} {2}", new DecimalFormat("0.0"));
        g2 = new BoxAndWhiskerToolTipGenerator("{0} --> {1} {2}", new DecimalFormat("0.00"));
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new BoxAndWhiskerToolTipGenerator("{0} --> {1} {2}", new DecimalFormat("0.0"));
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        BoxAndWhiskerToolTipGenerator g1 = new BoxAndWhiskerToolTipGenerator();
        BoxAndWhiskerToolTipGenerator g2 = null;
        try {
            g2 = (BoxAndWhiskerToolTipGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((g1 != g2 ? 1 : 0) != 0);
        Assert.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        BoxAndWhiskerToolTipGenerator g1 = new BoxAndWhiskerToolTipGenerator();
        BoxAndWhiskerToolTipGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (BoxAndWhiskerToolTipGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)g1, g2);
    }
}

