/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.CustomXYToolTipGenerator;

public class CustomXYItemLabelGeneratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.labels.junit.CustomXYItemLabelGeneratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CustomXYItemLabelGeneratorTests(String name) {
        super(name);
    }

    public void testCloning() {
        CustomXYToolTipGenerator g1 = new CustomXYToolTipGenerator();
        CustomXYToolTipGenerator g2 = null;
        try {
            g2 = (CustomXYToolTipGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CustomXYItemLabelGenerator.testCloning: failed to clone.");
        }
        Assert.assertTrue((g1 != g2 ? 1 : 0) != 0);
        Assert.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        ArrayList<String> t1 = new ArrayList<String>();
        t1.add("Tooltip A1");
        t1.add("Tooltip A2");
        t1.add("Tooltip A3");
        ArrayList<String> t2 = new ArrayList<String>();
        t2.add("Tooltip B1");
        t2.add("Tooltip B2");
        t2.add("Tooltip B3");
        CustomXYToolTipGenerator g1 = new CustomXYToolTipGenerator();
        g1.addToolTipSeries(t1);
        g1.addToolTipSeries(t2);
        CustomXYToolTipGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (CustomXYToolTipGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)g1, g2);
    }
}

