/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.IntervalCategoryLabelGenerator;

public class IntervalCategoryLabelGeneratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.labels.junit.IntervalCategoryLabelGeneratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public IntervalCategoryLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        IntervalCategoryLabelGenerator g1 = new IntervalCategoryLabelGenerator();
        IntervalCategoryLabelGenerator g2 = new IntervalCategoryLabelGenerator();
        Assert.assertTrue((boolean)g1.equals(g2));
        Assert.assertTrue((boolean)g2.equals(g1));
        g1 = new IntervalCategoryLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new IntervalCategoryLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        Assert.assertTrue((boolean)g1.equals(g2));
        g1 = new IntervalCategoryLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new IntervalCategoryLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        IntervalCategoryLabelGenerator g1 = new IntervalCategoryLabelGenerator();
        IntervalCategoryLabelGenerator g2 = null;
        try {
            g2 = (IntervalCategoryLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("IntervalCategoryItemLabelGenerator.testCloning: failed to clone.");
        }
        Assert.assertTrue((g1 != g2 ? 1 : 0) != 0);
        Assert.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        IntervalCategoryLabelGenerator g1 = new IntervalCategoryLabelGenerator("{3} - {4}", DateFormat.getInstance());
        IntervalCategoryLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (IntervalCategoryLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)g1, g2);
    }
}

