/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardXYLabelGenerator;

public class StandardXYLabelGeneratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.labels.junit.StandardXYLabelGeneratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public StandardXYLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        String f1 = "{1}";
        String f2 = "{2}";
        DecimalFormat xnf1 = new DecimalFormat("0.00");
        DecimalFormat xnf2 = new DecimalFormat("0.000");
        DecimalFormat ynf1 = new DecimalFormat("0.00");
        DecimalFormat ynf2 = new DecimalFormat("0.000");
        StandardXYLabelGenerator g1 = null;
        StandardXYLabelGenerator g2 = null;
        g1 = new StandardXYLabelGenerator(f1, xnf1, (NumberFormat)ynf1);
        g2 = new StandardXYLabelGenerator(f1, xnf1, (NumberFormat)ynf1);
        Assert.assertTrue((boolean)g1.equals(g2));
        Assert.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardXYLabelGenerator(f2, xnf1, (NumberFormat)ynf1);
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYLabelGenerator(f2, xnf1, (NumberFormat)ynf1);
        Assert.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYLabelGenerator(f2, xnf2, (NumberFormat)ynf1);
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYLabelGenerator(f2, xnf2, (NumberFormat)ynf1);
        Assert.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYLabelGenerator(f2, xnf2, (NumberFormat)ynf2);
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYLabelGenerator(f2, xnf2, (NumberFormat)ynf2);
        Assert.assertTrue((boolean)g1.equals(g2));
        SimpleDateFormat xdf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat xdf2 = new SimpleDateFormat("d-MMM-yyyy");
        SimpleDateFormat ydf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat ydf2 = new SimpleDateFormat("d-MMM-yyyy");
        g1 = new StandardXYLabelGenerator(f1, (DateFormat)xdf1, ydf1);
        g2 = new StandardXYLabelGenerator(f1, (DateFormat)xdf1, ydf1);
        Assert.assertTrue((boolean)g1.equals(g2));
        Assert.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardXYLabelGenerator(f1, (DateFormat)xdf2, ydf1);
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYLabelGenerator(f1, (DateFormat)xdf2, ydf1);
        Assert.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYLabelGenerator(f1, (DateFormat)xdf2, ydf2);
        Assert.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYLabelGenerator(f1, (DateFormat)xdf2, ydf2);
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardXYLabelGenerator g1 = new StandardXYLabelGenerator();
        StandardXYLabelGenerator g2 = null;
        try {
            g2 = (StandardXYLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Clone failed.");
        }
        Assert.assertTrue((g1 != g2 ? 1 : 0) != 0);
        Assert.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardXYLabelGenerator g1 = new StandardXYLabelGenerator();
        StandardXYLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardXYLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)g1, g2);
    }
}

