/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.Range;
import org.jfree.ui.Layer;
import org.jfree.ui.Spacer;
import org.jfree.util.SortOrder;

public class CategoryPlotTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.CategoryPlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CategoryPlotTests(String name) {
        super(name);
    }

    public void testAxisRange() {
        DefaultCategoryDataset datasetA = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetB = new DefaultCategoryDataset();
        datasetB.addValue(50.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        datasetB.addValue(80.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        CategoryPlot plot = new CategoryPlot(datasetA, new CategoryAxis(null), new NumberAxis(null), new LineAndShapeRenderer());
        plot.setDataset(1, datasetB);
        plot.setRenderer(1, new LineAndShapeRenderer());
        Range r = plot.getRangeAxis().getRange();
        Assert.assertEquals((double)84.0, (double)r.getUpperBound(), (double)1.0E-5);
    }

    public void testEquals() {
        CategoryPlot plot1 = new CategoryPlot();
        CategoryPlot plot2 = new CategoryPlot();
        Assert.assertTrue((boolean)plot1.equals(plot2));
        Assert.assertTrue((boolean)plot2.equals(plot1));
        plot1.setOrientation(PlotOrientation.HORIZONTAL);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setOrientation(PlotOrientation.HORIZONTAL);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAxisOffset(new Spacer(1, 0.05, 0.05, 0.05, 0.05));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAxisOffset(new Spacer(1, 0.05, 0.05, 0.05, 0.05));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(new CategoryAxis("Category Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(new CategoryAxis("Category Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDrawSharedDomainAxis(!plot1.getDrawSharedDomainAxis());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDrawSharedDomainAxis(!plot2.getDrawSharedDomainAxis());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(new NumberAxis("Range Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(new NumberAxis("Range Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToDomainAxis(11, 11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToDomainAxis(11, 11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToRangeAxis(11, 11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToRangeAxis(11, 11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(new AreaRenderer());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(new AreaRenderer());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(11, new AreaRenderer());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(11, new AreaRenderer());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setColumnRenderingOrder(SortOrder.DESCENDING);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setColumnRenderingOrder(SortOrder.DESCENDING);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRowRenderingOrder(SortOrder.DESCENDING);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRowRenderingOrder(SortOrder.DESCENDING);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinesVisible(true);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinesVisible(true);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePosition(CategoryAnchor.END);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePosition(CategoryAnchor.END);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke stroke = new BasicStroke(2.0f);
        plot1.setDomainGridlineStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlineStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinesVisible(false);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinesVisible(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlineStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlineStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinePaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinePaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAnchorValue(100.0);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAnchorValue(100.0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairVisible(true);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairVisible(true);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairValue(100.0);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairValue(100.0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairPaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairPaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairLockedOnData(false);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairLockedOnData(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWeight(3);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWeight(3);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setFixedDomainAxisSpace(new AxisSpace());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setFixedDomainAxisSpace(new AxisSpace());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setFixedRangeAxisSpace(new AxisSpace());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setFixedRangeAxisSpace(new AxisSpace());
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        CategoryPlot p1 = new CategoryPlot();
        CategoryPlot p2 = null;
        try {
            p2 = (CategoryPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("CategoryPlotTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((p1 != p2 ? 1 : 0) != 0);
        Assert.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        CategoryAxis domainAxis = new CategoryAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        BarRenderer renderer = new BarRenderer();
        CategoryPlot p1 = new CategoryPlot(data, domainAxis, rangeAxis, renderer);
        p1.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)p1, p2);
    }

    public void testSerialization2() {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        CategoryAxis domainAxis = new CategoryAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        BarRenderer renderer = new BarRenderer();
        CategoryPlot p1 = new CategoryPlot(data, domainAxis, rangeAxis, renderer);
        p1.setOrientation(PlotOrientation.VERTICAL);
        CategoryPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }

    public void testSerialization3() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart("Test Chart", "Category Axis", "Value Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }
}

