/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;

public class CombinedDomainCategoryPlotTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.CombinedDomainCategoryPlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CombinedDomainCategoryPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        CombinedDomainCategoryPlot plot1 = this.createPlot();
        CombinedDomainCategoryPlot plot2 = this.createPlot();
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        CombinedDomainCategoryPlot plot1 = this.createPlot();
        CombinedDomainCategoryPlot plot2 = null;
        try {
            plot2 = (CombinedDomainCategoryPlot)plot1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CombinedDomainCategoryPlotTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((plot1 != plot2 ? 1 : 0) != 0);
        Assert.assertTrue((plot1.getClass() == plot2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testSerialization() {
        CombinedDomainCategoryPlot plot1 = this.createPlot();
        CombinedDomainCategoryPlot plot2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(plot1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            plot2 = (CombinedDomainCategoryPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)plot1, plot2);
    }

    public CategoryDataset createDataset1() {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        String series1 = "First";
        String series2 = "Second";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        result.addValue(1.0, (Comparable)((Object)series1), (Comparable)((Object)type1));
        result.addValue(4.0, (Comparable)((Object)series1), (Comparable)((Object)type2));
        result.addValue(3.0, (Comparable)((Object)series1), (Comparable)((Object)type3));
        result.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type4));
        result.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type5));
        result.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type6));
        result.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type7));
        result.addValue(8.0, (Comparable)((Object)series1), (Comparable)((Object)type8));
        result.addValue(5.0, (Comparable)((Object)series2), (Comparable)((Object)type1));
        result.addValue(7.0, (Comparable)((Object)series2), (Comparable)((Object)type2));
        result.addValue(6.0, (Comparable)((Object)series2), (Comparable)((Object)type3));
        result.addValue(8.0, (Comparable)((Object)series2), (Comparable)((Object)type4));
        result.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type5));
        result.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type6));
        result.addValue(2.0, (Comparable)((Object)series2), (Comparable)((Object)type7));
        result.addValue(1.0, (Comparable)((Object)series2), (Comparable)((Object)type8));
        return result;
    }

    public CategoryDataset createDataset2() {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        String series1 = "Third";
        String series2 = "Fourth";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        result.addValue(11.0, (Comparable)((Object)series1), (Comparable)((Object)type1));
        result.addValue(14.0, (Comparable)((Object)series1), (Comparable)((Object)type2));
        result.addValue(13.0, (Comparable)((Object)series1), (Comparable)((Object)type3));
        result.addValue(15.0, (Comparable)((Object)series1), (Comparable)((Object)type4));
        result.addValue(15.0, (Comparable)((Object)series1), (Comparable)((Object)type5));
        result.addValue(17.0, (Comparable)((Object)series1), (Comparable)((Object)type6));
        result.addValue(17.0, (Comparable)((Object)series1), (Comparable)((Object)type7));
        result.addValue(18.0, (Comparable)((Object)series1), (Comparable)((Object)type8));
        result.addValue(15.0, (Comparable)((Object)series2), (Comparable)((Object)type1));
        result.addValue(17.0, (Comparable)((Object)series2), (Comparable)((Object)type2));
        result.addValue(16.0, (Comparable)((Object)series2), (Comparable)((Object)type3));
        result.addValue(18.0, (Comparable)((Object)series2), (Comparable)((Object)type4));
        result.addValue(14.0, (Comparable)((Object)series2), (Comparable)((Object)type5));
        result.addValue(14.0, (Comparable)((Object)series2), (Comparable)((Object)type6));
        result.addValue(12.0, (Comparable)((Object)series2), (Comparable)((Object)type7));
        result.addValue(11.0, (Comparable)((Object)series2), (Comparable)((Object)type8));
        return result;
    }

    private CombinedDomainCategoryPlot createPlot() {
        CategoryDataset dataset1 = this.createDataset1();
        NumberAxis rangeAxis1 = new NumberAxis("Value");
        rangeAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer1 = new LineAndShapeRenderer();
        renderer1.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot subplot1 = new CategoryPlot(dataset1, null, rangeAxis1, renderer1);
        subplot1.setDomainGridlinesVisible(true);
        CategoryDataset dataset2 = this.createDataset2();
        NumberAxis rangeAxis2 = new NumberAxis("Value");
        rangeAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer2 = new BarRenderer();
        renderer2.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot subplot2 = new CategoryPlot(dataset2, null, rangeAxis2, renderer2);
        subplot2.setDomainGridlinesVisible(true);
        CategoryAxis domainAxis = new CategoryAxis("Category");
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        plot.add(subplot1, 2);
        plot.add(subplot2, 1);
        return plot;
    }
}

