/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;

public class MeterPlotTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.MeterPlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public MeterPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        MeterPlot plot1 = new MeterPlot();
        MeterPlot plot2 = new MeterPlot();
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setUnits("mph");
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setUnits("mph");
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRange(new Range(50.0, 70.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRange(new Range(50.0, 70.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setNormalRange(new Range(55.0, 60.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setNormalRange(new Range(55.0, 60.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWarningRange(new Range(60.0, 65.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWarningRange(new Range(60.0, 65.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setCriticalRange(new Range(65.0, 70.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setCriticalRange(new Range(65.0, 70.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialOutlinePaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialOutlinePaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setNormalPaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setNormalPaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWarningPaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWarningPaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setCriticalPaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setCriticalPaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialShape(DialShape.CHORD);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialShape(DialShape.CHORD);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialBackgroundPaint(Color.yellow);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialBackgroundPaint(Color.yellow);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setNeedlePaint(Color.black);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setNeedlePaint(Color.black);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setValueFont(new Font("Serif", 0, 6));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setValueFont(new Font("Serif", 0, 6));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setValuePaint(Color.black);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setValuePaint(Color.black);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelType(0);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelType(0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelFont(new Font("Serif", 0, 6));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelFont(new Font("Serif", 0, 6));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelFormat(new DecimalFormat("0"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelFormat(new DecimalFormat("0"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDrawBorder(!plot1.getDrawBorder());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDrawBorder(plot1.getDrawBorder());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMeterAngle(22);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMeterAngle(22);
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        MeterPlot p1 = new MeterPlot();
        MeterPlot p2 = null;
        try {
            p2 = (MeterPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("MeterPlotTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((p1 != p2 ? 1 : 0) != 0);
        Assert.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        MeterPlot p1 = new MeterPlot(null);
        MeterPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (MeterPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }
}

