/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.util.Rotation;

public class PiePlotTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.PiePlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PiePlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        PiePlot plot1 = new PiePlot();
        PiePlot plot2 = new PiePlot();
        Assert.assertTrue((boolean)plot1.equals(plot2));
        Assert.assertTrue((boolean)plot2.equals(plot1));
        plot1.setPieIndex(99);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setPieIndex(99);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setInteriorGap(0.15);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setInteriorGap(0.15);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setCircular(!plot1.isCircular());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setCircular(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setStartAngle(Math.PI);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setStartAngle(Math.PI);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDirection(Rotation.ANTICLOCKWISE);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDirection(Rotation.ANTICLOCKWISE);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionPaint(2, Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionPaint(2, Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlinePaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlinePaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlinePaint(2, Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlinePaint(2, Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionOutlinePaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionOutlinePaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlineStroke(new BasicStroke(1.0f));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlineStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowXOffset(4.4);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowXOffset(4.4);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowYOffset(4.4);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowYOffset(4.4);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelFont(new Font("Serif", 0, 18));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelFont(new Font("Serif", 0, 18));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelBackgroundPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelBackgroundPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelOutlinePaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelOutlinePaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke s = new BasicStroke(1.1f);
        plot1.setLabelOutlineStroke(s);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelOutlineStroke(s);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelShadowPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelShadowPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setExplodePercent(3, 0.33);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setExplodePercent(3, 0.33);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        Font f = new Font("SansSerif", 0, 20);
        plot1.setLabelFont(f);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelFont(f);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelPaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelPaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMaximumLabelWidth(0.33);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMaximumLabelWidth(0.33);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelGap(0.11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelGap(0.11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkMargin(0.11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkMargin(0.11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkStroke(new BasicStroke(1.0f));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setURLGenerator(new StandardPieURLGenerator("xx"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setURLGenerator(new StandardPieURLGenerator("xx"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMinimumArcAngleToDraw(1.0);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMinimumArcAngleToDraw(1.0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        PiePlot p1 = new PiePlot();
        PiePlot p2 = null;
        try {
            p2 = (PiePlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("PiePlotTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((p1 != p2 ? 1 : 0) != 0);
        Assert.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        PiePlot p1 = new PiePlot(null);
        PiePlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (PiePlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }
}

