/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.UnitType;

public class ValueMarkerTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.ValueMarkerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ValueMarkerTests(String name) {
        super(name);
    }

    public void testEquals() {
        ValueMarker m1 = new ValueMarker(45.0);
        ValueMarker m2 = new ValueMarker(45.0);
        Assert.assertTrue((boolean)m1.equals(m2));
        Assert.assertTrue((boolean)m2.equals(m1));
        m1.setPaint(Color.red);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setPaint(Color.red);
        Assert.assertTrue((boolean)m1.equals(m2));
        BasicStroke stroke = new BasicStroke(2.2f);
        m1.setStroke(stroke);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setStroke(stroke);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setOutlinePaint(Color.red);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setOutlinePaint(Color.red);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setOutlineStroke(stroke);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setOutlineStroke(stroke);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setAlpha(0.1f);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setAlpha(0.1f);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabel("New Label");
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabel("New Label");
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabelFont(new Font("SansSerif", 0, 10));
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabelFont(new Font("SansSerif", 0, 10));
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabelPaint(Color.red);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabelPaint(Color.red);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        Assert.assertTrue((boolean)m1.equals(m2));
        m1.setLabelOffset(new RectangleInsets(UnitType.ABSOLUTE, 10.0, 10.0, 10.0, 10.0));
        Assert.assertFalse((boolean)m1.equals(m2));
        m2.setLabelOffset(new RectangleInsets(UnitType.ABSOLUTE, 10.0, 10.0, 10.0, 10.0));
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testCloning() {
        ValueMarker m1 = new ValueMarker(25.0);
        ValueMarker m2 = null;
        try {
            m2 = (ValueMarker)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((m1 != m2 ? 1 : 0) != 0);
        Assert.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        ValueMarker m1 = new ValueMarker(25.0);
        ValueMarker m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (ValueMarker)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = m1.equals(m2);
        Assert.assertTrue((boolean)b);
    }
}

