/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.DefaultXYItemRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYSeriesCollection;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.Spacer;

public class XYPlotTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.junit.XYPlotTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYPlot plot1 = new XYPlot();
        XYPlot plot2 = new XYPlot();
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setOrientation(PlotOrientation.HORIZONTAL);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setOrientation(PlotOrientation.HORIZONTAL);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setAxisOffset(new Spacer(1, 0.05, 0.05, 0.05, 0.05));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setAxisOffset(new Spacer(1, 0.05, 0.05, 0.05, 0.05));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(new NumberAxis("Domain Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(new NumberAxis("Domain Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(new NumberAxis("Range Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(new NumberAxis("Range Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToDomainAxis(11, 11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToDomainAxis(11, 11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.mapDatasetToRangeAxis(11, 11);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.mapDatasetToRangeAxis(11, 11);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(new DefaultXYItemRenderer());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(new DefaultXYItemRenderer());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRenderer(11, new DefaultXYItemRenderer());
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRenderer(11, new DefaultXYItemRenderer());
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinesVisible(false);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinesVisible(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke stroke = new BasicStroke(2.0f);
        plot1.setDomainGridlineStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlineStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDomainGridlinePaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDomainGridlinePaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinesVisible(false);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinesVisible(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlineStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlineStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeGridlinePaint(Color.blue);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeGridlinePaint(Color.blue);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairVisible(true);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairVisible(true);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairValue(100.0);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairValue(100.0);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairStroke(stroke);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairStroke(stroke);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairPaint(Color.red);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairPaint(Color.red);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRangeCrosshairLockedOnData(false);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRangeCrosshairLockedOnData(false);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(new ValueMarker(4.0));
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(new ValueMarker(4.0));
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        Assert.assertTrue((boolean)plot1.equals(plot2));
        plot1.setWeight(3);
        Assert.assertFalse((boolean)plot1.equals(plot2));
        plot2.setWeight(3);
        Assert.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        XYPlot p1 = new XYPlot();
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("XYPlotTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((p1 != p2 ? 1 : 0) != 0);
        Assert.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testCloning2() {
        XYPlot p1 = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        p1.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        p1.setRenderer(1, new XYBarRenderer());
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((p1 != p2 ? 1 : 0) != 0);
        Assert.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testCloneIndependence() {
        XYPlot p1 = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        p1.setDomainAxis(1, new NumberAxis("Domain Axis 2"));
        p1.setDomainAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        p1.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        p1.setRangeAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        p1.setRenderer(1, new XYBarRenderer());
        XYPlot p2 = null;
        try {
            p2 = (XYPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getDomainAxis().setLabel("Label");
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getDomainAxis().setLabel("Label");
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getDomainAxis(1).setLabel("S1");
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getDomainAxis(1).setLabel("S1");
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getRangeAxis().setLabel("Label");
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getRangeAxis().setLabel("Label");
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getRangeAxis(1).setLabel("S1");
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getRangeAxis(1).setLabel("S1");
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getRenderer().setOutlinePaint(Color.cyan);
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getRenderer().setOutlinePaint(Color.cyan);
        Assert.assertTrue((boolean)p1.equals(p2));
        p1.getRenderer(1).setOutlinePaint(Color.red);
        Assert.assertFalse((boolean)p1.equals(p2));
        p2.getRenderer(1).setOutlinePaint(Color.red);
        Assert.assertTrue((boolean)p1.equals(p2));
    }

    public void testSetNullRenderer() {
        boolean failed = false;
        try {
            XYPlot plot = new XYPlot(null, new NumberAxis("X"), new NumberAxis("Y"), null);
            plot.setRenderer(null);
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertTrue((!failed ? 1 : 0) != 0);
    }

    public void testSerialization1() {
        XYSeriesCollection data = new XYSeriesCollection();
        NumberAxis domainAxis = new NumberAxis("Domain");
        NumberAxis rangeAxis = new NumberAxis("Range");
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        XYPlot p1 = new XYPlot(data, domainAxis, rangeAxis, renderer);
        XYPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (XYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }

    public void testSerialization2() {
        IntervalXYDataset data1 = this.createDataset1();
        XYBarRenderer renderer1 = new XYBarRenderer(0.2);
        renderer1.setToolTipGenerator(StandardXYToolTipGenerator.getTimeSeriesInstance());
        XYPlot p1 = new XYPlot(data1, new DateAxis("Date"), null, renderer1);
        XYPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (XYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)p1, p2);
    }

    public void testSerialization3() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart("Test Chart", "Domain Axis", "Range Axis", dataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart chart2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(chart);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            chart2 = (JFreeChart)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean passed = true;
        try {
            chart2.createBufferedImage(300, 200);
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }

    private IntervalXYDataset createDataset1() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series1 = new TimeSeries("Series 1", clazz);
        series1.add((RegularTimePeriod)new Day(1, 3, 2002), 12353.3);
        series1.add((RegularTimePeriod)new Day(2, 3, 2002), 13734.4);
        series1.add((RegularTimePeriod)new Day(3, 3, 2002), 14525.3);
        series1.add((RegularTimePeriod)new Day(4, 3, 2002), 13984.3);
        series1.add((RegularTimePeriod)new Day(5, 3, 2002), 12999.4);
        series1.add((RegularTimePeriod)new Day(6, 3, 2002), 14274.3);
        series1.add((RegularTimePeriod)new Day(7, 3, 2002), 15943.5);
        series1.add((RegularTimePeriod)new Day(8, 3, 2002), 14845.3);
        series1.add((RegularTimePeriod)new Day(9, 3, 2002), 14645.4);
        series1.add((RegularTimePeriod)new Day(10, 3, 2002), 16234.6);
        series1.add((RegularTimePeriod)new Day(11, 3, 2002), 17232.3);
        series1.add((RegularTimePeriod)new Day(12, 3, 2002), 14232.2);
        series1.add((RegularTimePeriod)new Day(13, 3, 2002), 13102.2);
        series1.add((RegularTimePeriod)new Day(14, 3, 2002), 14230.2);
        series1.add((RegularTimePeriod)new Day(15, 3, 2002), 11235.2);
        TimeSeriesCollection collection = new TimeSeriesCollection(series1);
        collection.setDomainIsPointsInTime(false);
        return collection;
    }
}

