/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.data.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private XYPlot plot;
    private XYLabelGenerator itemLabelGenerator = null;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private XYLabelGenerator baseItemLabelGenerator;
    private XYToolTipGenerator toolTipGenerator = null;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.AbstractXYItemRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    protected AbstractXYItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot plot) {
        this.plot = plot;
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = new XYItemRendererState(info);
        return state;
    }

    public XYLabelGenerator getLabelGenerator(int row, int column) {
        return this.getSeriesLabelGenerator(row);
    }

    public XYLabelGenerator getSeriesLabelGenerator(int series) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        XYLabelGenerator generator = (XYLabelGenerator)this.itemLabelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemLabelGenerator;
        }
        return generator;
    }

    public void setLabelGenerator(XYLabelGenerator generator) {
        this.itemLabelGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLabelGenerator(int series, XYLabelGenerator generator) {
        this.itemLabelGeneratorList.set(series, generator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYLabelGenerator getBaseLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseLabelGenerator(XYLabelGenerator generator) {
        this.baseItemLabelGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getToolTipGenerator(int row, int column) {
        return this.getSeriesToolTipGenerator(row);
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int series) {
        if (this.toolTipGenerator != null) {
            return this.toolTipGenerator;
        }
        XYToolTipGenerator generator = (XYToolTipGenerator)this.toolTipGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseToolTipGenerator;
        }
        return generator;
    }

    public void setToolTipGenerator(XYToolTipGenerator generator) {
        this.toolTipGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesToolTipGenerator(int series, XYToolTipGenerator generator) {
        this.toolTipGeneratorList.set(series, generator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(XYToolTipGenerator generator) {
        this.baseToolTipGenerator = generator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public RangeType getRangeType() {
        return RangeType.STANDARD;
    }

    public Range getRangeExtent(XYDataset dataset) {
        return DatasetUtilities.findRangeExtent(dataset);
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot xyplot = this.getPlot();
        if (xyplot != null && (dataset = xyplot.getDataset(datasetIndex)) != null) {
            String label;
            String description = label = dataset.getSeriesName(series);
            Shape shape = this.getSeriesShape(series);
            Paint paint = this.getSeriesPaint(series);
            Paint outlinePaint = this.getSeriesOutlinePaint(series);
            Stroke stroke = this.getSeriesStroke(series);
            result = new LegendItem(label, description, shape, true, paint, stroke, outlinePaint, stroke);
        }
        return result;
    }

    public void fillDomainGridBand(Graphics2D g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double start, double end) {
        double x1 = axis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
        double x2 = axis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
        Rectangle2D.Double band = new Rectangle2D.Double(x1, dataArea.getMinY(), x2 - x1, dataArea.getMaxY() - dataArea.getMinY());
        Paint paint = plot.getDomainTickBandPaint();
        if (paint != null) {
            g2.setPaint(paint);
            g2.fill(band);
        }
    }

    public void fillRangeGridBand(Graphics2D g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double start, double end) {
        double y1 = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
        double y2 = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
        Rectangle2D.Double band = new Rectangle2D.Double(dataArea.getMinX(), y2, dataArea.getWidth(), y1 - y2);
        Paint paint = plot.getRangeTickBandPaint();
        if (paint != null) {
            g2.setPaint(paint);
            g2.fill(band);
        }
    }

    public void drawDomainGridLine(Graphics2D g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
        Line2D.Double line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        }
        Paint paint = plot.getDomainGridlinePaint();
        Stroke stroke = plot.getDomainGridlineStroke();
        g2.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        g2.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        g2.draw(line);
    }

    public void drawRangeGridLine(Graphics2D g2, XYPlot plot, ValueAxis axis, Rectangle2D dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Line2D.Double line = null;
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
        }
        Paint paint = plot.getRangeGridlinePaint();
        Stroke stroke = plot.getRangeGridlineStroke();
        g2.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        g2.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        g2.draw(line);
    }

    public void drawDomainMarker(Graphics2D g2, XYPlot plot, ValueAxis domainAxis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = domainAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = domainAxis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            }
            g2.setPaint(marker.getPaint());
            g2.setStroke(marker.getStroke());
            g2.draw(line);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), anchor, false);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates[0], (float)coordinates[1], marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = domainAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            start = range.constrain(start);
            end = range.constrain(end);
            double v0 = domainAxis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
            double v1 = domainAxis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Rectangle2D.Double rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                rect = new Rectangle2D.Double(dataArea.getMinX(), Math.min(v0, v1), dataArea.getWidth(), Math.abs(v1 - v0));
            } else if (orientation == PlotOrientation.VERTICAL) {
                rect = new Rectangle2D.Double(Math.min(v0, v1), dataArea.getMinY(), Math.abs(v1 - v0), dataArea.getHeight());
            }
            Paint p = marker.getPaint();
            if (p instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)p;
                GradientPaintTransformer t = im.getGradientPaintTransformer();
                if (t != null) {
                    gp = t.transform(gp, rect);
                }
                g2.setPaint(gp);
            } else {
                g2.setPaint(p);
            }
            g2.fill(rect);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, rect, marker.getLabelOffset(), anchor, true);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates[0], (float)coordinates[1], marker.getLabelTextAnchor());
            }
        }
    }

    private double[] calculateDomainMarkerTextAnchorPoint(Graphics2D g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, RectangleAnchor anchor, boolean inset) {
        double[] result = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D anchorRect = null;
            anchorRect = inset ? markerOffset.createInsetRectangle(markerArea, false, true) : markerOffset.createOutsetRectangle(markerArea, false, true);
            result = RectangleAnchor.coordinates(anchorRect, anchor);
        } else if (orientation == PlotOrientation.VERTICAL) {
            Rectangle2D anchorRect = null;
            anchorRect = inset ? markerOffset.createInsetRectangle(markerArea, false, true) : markerOffset.createOutsetRectangle(markerArea, false, true);
            result = RectangleAnchor.coordinates(anchorRect, anchor);
        }
        return result;
    }

    public void drawRangeMarker(Graphics2D g2, XYPlot plot, ValueAxis rangeAxis, Marker marker, Rectangle2D dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = rangeAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Line2D.Double line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new Line2D.Double(v, dataArea.getMinY(), v, dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new Line2D.Double(dataArea.getMinX(), v, dataArea.getMaxX(), v);
            }
            g2.setPaint(marker.getPaint());
            g2.setStroke(marker.getStroke());
            g2.draw(line);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateRangeMarkerTextAnchorPoint(g2, orientation, dataArea, line.getBounds2D(), marker.getLabelOffset(), anchor);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates[0], (float)coordinates[1], marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = rangeAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            start = range.constrain(start);
            end = range.constrain(end);
            double v0 = rangeAxis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double v1 = rangeAxis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            Rectangle2D.Double rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                rect = new Rectangle2D.Double(Math.min(v0, v1), dataArea.getMinY(), Math.abs(v1 - v0), dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                rect = new Rectangle2D.Double(dataArea.getMinX(), Math.min(v0, v1), dataArea.getWidth(), Math.abs(v0 - v1));
            }
            Paint p = marker.getPaint();
            if (p instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)p;
                GradientPaintTransformer t = im.getGradientPaintTransformer();
                if (t != null) {
                    gp = t.transform(gp, rect);
                }
                g2.setPaint(gp);
            } else {
                g2.setPaint(p);
            }
            g2.fill(rect);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                g2.setFont(labelFont);
                g2.setPaint(marker.getLabelPaint());
                double[] coordinates = this.calculateDomainMarkerTextAnchorPoint(g2, orientation, dataArea, rect, marker.getLabelOffset(), anchor, true);
                TextUtilities.drawAlignedString(label, g2, (float)coordinates[0], (float)coordinates[1], marker.getLabelTextAnchor());
            }
        }
    }

    private double[] calculateRangeMarkerTextAnchorPoint(Graphics2D g2, PlotOrientation orientation, Rectangle2D dataArea, Rectangle2D markerArea, RectangleInsets markerOffset, RectangleAnchor anchor) {
        double[] result = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D anchorRect = markerOffset.createOutsetRectangle(markerArea, true, false);
            result = RectangleAnchor.coordinates(anchorRect, anchor);
        } else if (orientation == PlotOrientation.VERTICAL) {
            Rectangle2D anchorRect = markerOffset.createOutsetRectangle(markerArea, false, true);
            result = RectangleAnchor.coordinates(anchorRect, anchor);
        }
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractXYItemRenderer clone = (AbstractXYItemRenderer)super.clone();
        if (this.itemLabelGenerator != null && this.itemLabelGenerator instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)((Object)this.itemLabelGenerator);
            clone.itemLabelGenerator = (XYLabelGenerator)pc.clone();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!ObjectUtils.equal(this.itemLabelGenerator, renderer.itemLabelGenerator)) {
            return false;
        }
        return ObjectUtils.equal(this.urlGenerator, renderer.urlGenerator);
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        XYPlot p = this.getPlot();
        if (p != null) {
            result = p.getDrawingSupplier();
        }
        return result;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double x, double y, double transX, double transY, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(x, y, transX, transY, orientation);
                } else {
                    crosshairState.updateCrosshairX(x);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(y);
            }
        }
    }

    protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
        XYLabelGenerator generator = this.getLabelGenerator(series, item);
        if (generator != null) {
            Font labelFont = this.getItemLabelFont(series, item);
            Paint paint = this.getItemLabelPaint(series, item);
            g2.setFont(labelFont);
            g2.setPaint(paint);
            String label = generator.generateLabel(dataset, series, item);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
            Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            RefineryUtilities.drawRotatedString(label, g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getTextAnchor(), position.getRotationAnchor(), position.getAngle());
        }
    }
}

