/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StackedXYBarRenderer
extends XYBarRenderer {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StackedXYBarRenderer() {
    }

    public StackedXYBarRenderer(double margin) {
        super(margin);
    }

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    public Range getRangeExtent(XYDataset dataset) {
        return DatasetUtilities.getStackedRangeExtent((TableXYDataset)dataset);
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        return new StackedXYBarRendererState(info);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        if (!(dataset instanceof IntervalXYDataset) || !(dataset instanceof TableXYDataset)) {
            Class<?> clazz;
            String message = "dataset (type " + dataset.getClass().getName() + ") has wrong type:";
            boolean and = false;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.jfree.data.IntervalXYDataset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(dataset.getClass())) {
                message = String.valueOf(message) + " it is no IntervalXYDataset";
                and = true;
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.jfree.data.TableXYDataset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(dataset.getClass())) {
                if (and) {
                    message = String.valueOf(message) + " and";
                }
                message = String.valueOf(message) + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(message);
        }
        IntervalXYDataset intervalData = (IntervalXYDataset)dataset;
        Paint seriesPaint = this.getItemPaint(series, item);
        Paint seriesOutlinePaint = this.getItemOutlinePaint(series, item);
        double ph = this.getPreviousHeight(dataset, series, item);
        Number valueNumber = intervalData.getYValue(series, item);
        if (valueNumber == null) {
            return;
        }
        double translatedStartY = rangeAxis.valueToJava2D(ph, dataArea, plot.getRangeAxisEdge());
        double translatedEndY = rangeAxis.valueToJava2D(valueNumber.doubleValue() + ph, dataArea, plot.getRangeAxisEdge());
        RectangleEdge location = plot.getDomainAxisEdge();
        Number startXNumber = intervalData.getStartXValue(series, item);
        if (startXNumber == null) {
            return;
        }
        double translatedStartX = domainAxis.valueToJava2D(startXNumber.doubleValue(), dataArea, location);
        Number endXNumber = intervalData.getEndXValue(series, item);
        if (endXNumber == null) {
            return;
        }
        double translatedEndX = domainAxis.valueToJava2D(endXNumber.doubleValue(), dataArea, location);
        double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
        double translatedHeight = Math.abs(translatedEndY - translatedStartY);
        if (this.getMargin() > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            translatedStartX += cut / 2.0;
        }
        Rectangle2D.Double bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar = new Rectangle2D.Double(Math.min(translatedStartY, translatedEndY), translatedEndX, translatedHeight, translatedWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bar = new Rectangle2D.Double(translatedStartX, Math.min(translatedStartY, translatedEndY), translatedWidth, translatedHeight);
        }
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (Math.abs(translatedEndX - translatedStartX) > 3.0) {
            g2.setStroke(this.getItemStroke(series, item));
            g2.setPaint(seriesOutlinePaint);
            g2.draw(bar);
        }
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(bar, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    protected double getPreviousHeight(XYDataset data, int series, int index) {
        double result = 0.0;
        int i = 0;
        while (i < series) {
            Number tmp = data.getYValue(i, index);
            if (tmp != null) {
                result += tmp.doubleValue();
            }
            ++i;
        }
        return result;
    }

    static class StackedXYBarRendererState
    extends XYItemRendererState {
        public StackedXYBarRendererState(PlotRenderingInfo info) {
            super(info);
        }
    }
}

