/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.junit.RendererChangeDetector;
import org.jfree.ui.TextAnchor;

public class AbstractRendererTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.junit.AbstractRendererTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public AbstractRendererTests(String name) {
        super(name);
    }

    public void testEventNotification() {
        RendererChangeDetector detector = new RendererChangeDetector();
        BarRenderer r1 = new BarRenderer();
        r1.addChangeListener(detector);
        detector.setNotified(false);
        r1.setPaint(Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesPaint(0, Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBasePaint(Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setOutlinePaint(Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesOutlinePaint(0, Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseOutlinePaint(Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesStroke(0, new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setOutlineStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesOutlineStroke(0, new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseOutlineStroke(new BasicStroke(1.0f));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setShape(new Rectangle2D.Float());
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesShape(0, new Rectangle2D.Float());
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseShape(new Rectangle2D.Float());
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelsVisible(Boolean.TRUE);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelsVisible(0, Boolean.TRUE);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelsVisible(Boolean.TRUE);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelFont(new Font("Serif", 0, 12));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelFont(0, new Font("Serif", 0, 12));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelFont(new Font("Serif", 0, 12));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setItemLabelPaint(Color.blue);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesItemLabelPaint(0, Color.blue);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseItemLabelPaint(Color.blue);
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
        detector.setNotified(false);
        r1.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        Assert.assertTrue((boolean)detector.getNotified());
    }

    public void testSerialization() {
        BarRenderer r1 = new BarRenderer();
        AbstractRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (BarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
        try {
            r2.notifyListeners(new RendererChangeEvent(r2));
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)false);
        }
    }
}

