/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.junit.RendererChangeDetector;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;

public class BarRendererTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.junit.BarRendererTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        BarRenderer r1 = new BarRenderer();
        BarRenderer r2 = new BarRenderer();
        Assert.assertTrue((boolean)r1.equals(r2));
        Assert.assertTrue((boolean)r2.equals(r1));
        r1.setItemMargin(0.22);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setItemMargin(0.22);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setDrawBarOutline(!r1.isDrawBarOutline());
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setDrawBarOutline(!r2.isDrawBarOutline());
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setMaxBarWidth(0.11);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setMaxBarWidth(0.11);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setMinimumBarLength(0.04);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setMinimumBarLength(0.04);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setNegativeItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setNegativeItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        BarRenderer r1 = new BarRenderer();
        BarRenderer r2 = new BarRenderer();
        Assert.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        BarRenderer r1 = new BarRenderer();
        r1.setLabelGenerator(new StandardCategoryLabelGenerator());
        BarRenderer r2 = null;
        try {
            r2 = (BarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("BarRendererTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((r1 != r2 ? 1 : 0) != 0);
        Assert.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        BarRenderer r1 = new BarRenderer();
        BarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (BarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
    }

    public void testEventNotification() {
        RendererChangeDetector detector = new RendererChangeDetector();
        BarRenderer r1 = new BarRenderer();
        r1.addChangeListener(detector);
        detector.setNotified(false);
        r1.setPaint(Color.red);
        Assert.assertTrue((boolean)detector.getNotified());
    }
}

