/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.BoxAndWhiskerRenderer;

public class BoxAndWhiskerRendererTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.junit.BoxAndWhiskerRendererTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BoxAndWhiskerRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        BoxAndWhiskerRenderer r1 = new BoxAndWhiskerRenderer();
        BoxAndWhiskerRenderer r2 = new BoxAndWhiskerRenderer();
        Assert.assertEquals((Object)r1, (Object)r2);
        r1.setArtifactPaint(Color.yellow);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setArtifactPaint(Color.yellow);
        Assert.assertEquals((Object)r1, (Object)r2);
        r1.setFillBox(!r1.getFillBox());
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setFillBox(!r2.getFillBox());
        Assert.assertEquals((Object)r1, (Object)r2);
        r1.setItemMargin(0.11);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setItemMargin(0.11);
        Assert.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        BoxAndWhiskerRenderer r1 = new BoxAndWhiskerRenderer();
        BoxAndWhiskerRenderer r2 = new BoxAndWhiskerRenderer();
        Assert.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        BoxAndWhiskerRenderer r1 = new BoxAndWhiskerRenderer();
        BoxAndWhiskerRenderer r2 = null;
        try {
            r2 = (BoxAndWhiskerRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("BoxAndWhiskerRendererTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((r1 != r2 ? 1 : 0) != 0);
        Assert.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        BoxAndWhiskerRenderer r1 = new BoxAndWhiskerRenderer();
        BoxAndWhiskerRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (BoxAndWhiskerRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
    }
}

