/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.WaterfallBarRenderer;

public class WaterfallBarRendererTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.junit.WaterfallBarRendererTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public WaterfallBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = new WaterfallBarRenderer();
        Assert.assertEquals((Object)r1, (Object)r2);
        r1.setFirstBarPaint(Color.cyan);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setFirstBarPaint(Color.cyan);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setLastBarPaint(Color.cyan);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setLastBarPaint(Color.cyan);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setPositiveBarPaint(Color.cyan);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setPositiveBarPaint(Color.cyan);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setNegativeBarPaint(Color.cyan);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setNegativeBarPaint(Color.cyan);
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = new WaterfallBarRenderer();
        Assert.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = null;
        try {
            r2 = (WaterfallBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("WaterfallBarRendererTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((r1 != r2 ? 1 : 0) != 0);
        Assert.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r1.equals(r2));
        r1.setFirstBarPaint(Color.yellow);
        Assert.assertFalse((boolean)r1.equals(r2));
        r2.setFirstBarPaint(Color.yellow);
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        WaterfallBarRenderer r1 = new WaterfallBarRenderer();
        WaterfallBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (WaterfallBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
    }
}

