/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.XYDifferenceRenderer;

public class XYDifferenceRendererTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.junit.XYDifferenceRendererTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYDifferenceRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        Assert.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        Assert.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = null;
        try {
            r2 = (XYDifferenceRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYDifferenceRendererTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((r1 != r2 ? 1 : 0) != 0);
        Assert.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYDifferenceRenderer r1 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYDifferenceRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)r1, r2);
    }
}

