/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.event.TitleChangeListener;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.ObjectUtils;

public abstract class Title
implements Cloneable,
Serializable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int MIDDLE = 4;
    public static final RectangleEdge DEFAULT_POSITION = RectangleEdge.TOP;
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.CENTER;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.CENTER;
    public static final Spacer DEFAULT_SPACER = new Spacer(0, 0.01, 0.15, 0.01, 0.15);
    private RectangleEdge position;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Spacer spacer;
    private transient EventListenerList listenerList;
    private boolean notify;
    static /* synthetic */ Class class$0;

    protected Title() {
        this(DEFAULT_POSITION, DEFAULT_HORIZONTAL_ALIGNMENT, DEFAULT_VERTICAL_ALIGNMENT, DEFAULT_SPACER);
    }

    protected Title(RectangleEdge position, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(position, horizontalAlignment, verticalAlignment, DEFAULT_SPACER);
    }

    protected Title(RectangleEdge position, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, Spacer spacer) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 'position' cannot be null.");
        }
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("Null 'horizontalAlignment' argument.");
        }
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("Null 'verticalAlignment' argument.");
        }
        if (spacer == null) {
            throw new IllegalArgumentException("Argument 'spacer' cannot be null.");
        }
        this.position = position;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.spacer = spacer;
        this.listenerList = new EventListenerList();
        this.notify = true;
    }

    public RectangleEdge getPosition() {
        return this.position;
    }

    public void setPosition(RectangleEdge position) {
        if (position == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        if (this.position != position) {
            this.position = position;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Null 'alignment' argument.");
        }
        if (this.horizontalAlignment != alignment) {
            this.horizontalAlignment = alignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Argument 'alignment' cannot be null.");
        }
        if (this.verticalAlignment != alignment) {
            this.verticalAlignment = alignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public void setSpacer(Spacer spacer) {
        if (spacer == null) {
            throw new NullPointerException("AbstractTitle.setSpacer(): null not permitted.");
        }
        if (!this.spacer.equals(spacer)) {
            this.spacer = spacer;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean flag) {
        this.notify = flag;
    }

    public abstract float getPreferredWidth(Graphics2D var1, float var2);

    public abstract float getPreferredHeight(Graphics2D var1, float var2);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Object clone() throws CloneNotSupportedException {
        Title duplicate = (Title)super.clone();
        duplicate.listenerList = new EventListenerList();
        return duplicate;
    }

    public void addChangeListener(TitleChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.TitleChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(TitleChangeListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.TitleChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, listener);
    }

    protected void notifyListeners(TitleChangeEvent event) {
        if (this.notify) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                Object object = listeners[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.jfree.chart.event.TitleChangeListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object == clazz) {
                    ((TitleChangeListener)listeners[i + 1]).titleChanged(event);
                }
                i -= 2;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Title) {
            Title t = (Title)obj;
            if (this.position != t.position) {
                return false;
            }
            if (this.horizontalAlignment != t.horizontalAlignment) {
                return false;
            }
            if (this.verticalAlignment != t.verticalAlignment) {
                return false;
            }
            if (!ObjectUtils.equal(this.spacer, t.spacer)) {
                return false;
            }
            return this.notify == t.notify;
        }
        return false;
    }

    public int hashCode() {
        int result = 193;
        result = 37 * result + ObjectUtils.hashCode(this.position);
        result = 37 * result + ObjectUtils.hashCode(this.horizontalAlignment);
        result = 37 * result + ObjectUtils.hashCode(this.verticalAlignment);
        result = 37 * result + ObjectUtils.hashCode(this.spacer);
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

