/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.title.TextTitle;

public class TextTitleTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.title.junit.TextTitleTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TextTitleTests(String name) {
        super(name);
    }

    public void testEquals() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = new TextTitle();
        Assert.assertEquals((Object)t1, (Object)t2);
        t1.setText("Test 1");
        Assert.assertFalse((boolean)t1.equals(t2));
        t2.setText("Test 1");
        Assert.assertTrue((boolean)t1.equals(t2));
        Font f = new Font("SansSerif", 0, 15);
        t1.setFont(f);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2.setFont(f);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1.setPaint(Color.blue);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2.setPaint(Color.blue);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1.setBackgroundPaint(Color.blue);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2.setBackgroundPaint(Color.blue);
        Assert.assertTrue((boolean)t1.equals(t2));
    }

    public void testHashcode() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = new TextTitle();
        Assert.assertTrue((boolean)t1.equals(t2));
        int h1 = t1.hashCode();
        int h2 = t2.hashCode();
        Assert.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = null;
        try {
            t2 = (TextTitle)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("TextTitleTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((t1 != t2 ? 1 : 0) != 0);
        Assert.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        TextTitle t1 = new TextTitle("Test");
        TextTitle t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (TextTitle)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)t1, t2);
    }
}

