/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class CustomXYURLGenerator
implements XYURLGenerator,
Serializable {
    private ArrayList urlSeries = new ArrayList();

    public int getListCount() {
        return this.urlSeries.size();
    }

    public int getURLCount(int list) {
        int result = 0;
        List tooltips = (List)this.urlSeries.get(list);
        if (tooltips != null) {
            result = tooltips.size();
        }
        return result;
    }

    public String getURL(int series, int item) {
        List tooltips;
        String result = null;
        if (series < this.getListCount() && (tooltips = (List)this.urlSeries.get(series)) != null && item < tooltips.size()) {
            result = (String)tooltips.get(item);
        }
        return result;
    }

    public String generateURL(XYDataset data, int series, int item) {
        return this.getURL(series, item);
    }

    public void addURLSeries(List urls) {
        this.urlSeries.add(urls);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomXYURLGenerator)) {
            return false;
        }
        CustomXYURLGenerator generator = (CustomXYURLGenerator)o;
        int listCount = this.getListCount();
        if (listCount != generator.getListCount()) {
            return false;
        }
        int series = 0;
        while (series < listCount) {
            int urlCount = this.getURLCount(series);
            if (urlCount != generator.getURLCount(series)) {
                return false;
            }
            int item = 0;
            while (item < urlCount) {
                String u1 = this.getURL(series, item);
                String u2 = generator.getURL(series, item);
                if (u1 != null ? !u1.equals(u2) : u2 != null) {
                    return false;
                }
                ++item;
            }
            ++series;
        }
        return true;
    }
}

