/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.PieDataset;

public class StandardPieURLGenerator
implements PieURLGenerator,
Serializable {
    private String prefix = "index.html";
    private String categoryParameterName = "category";
    private String indexParameterName = "pieIndex";

    public StandardPieURLGenerator() {
    }

    public StandardPieURLGenerator(String prefix) {
        this.prefix = prefix;
    }

    public StandardPieURLGenerator(String prefix, String categoryParameterName) {
        this.prefix = prefix;
        this.categoryParameterName = categoryParameterName;
    }

    public StandardPieURLGenerator(String prefix, String categoryParameterName, String indexParameterName) {
        this.prefix = prefix;
        this.categoryParameterName = categoryParameterName;
        this.indexParameterName = indexParameterName;
    }

    public String generateURL(PieDataset data, Comparable key, int pieIndex) {
        String url = this.prefix;
        url = url.indexOf("?") > -1 ? String.valueOf(url) + "&" + this.categoryParameterName + "=" + key.toString() : String.valueOf(url) + "?" + this.categoryParameterName + "=" + key.toString();
        if (this.indexParameterName != null) {
            url = String.valueOf(url) + "&" + this.indexParameterName + "=" + String.valueOf(pieIndex);
        }
        return url;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPieURLGenerator)) {
            return false;
        }
        StandardPieURLGenerator generator = (StandardPieURLGenerator)o;
        return this.categoryParameterName.equals(generator.categoryParameterName) && this.prefix.equals(generator.prefix);
    }
}

